# Webform QR Code Element

[![Screenshot of the
settings](https://www.drupal.org/files/issues/2025-05-25/settings_webform_qr_code_element.png){align="right"
width="30%"}](https://www.drupal.org/files/issues/2025-05-25/settings_webform_qr_code_element.png)

This module supplies a Webform element that generates a QR code. It is
intended for emails sent to event participants and can be used for
faster check-in. The QR code can be shown on the web, in the email body
or as an attachment (PDF, PNG).

The QR code is only visible after the form is submitted, not while it is
being filled out.

## PDF attachment

This module allows to attach a customizable, dynamic PDF to emails, for
example \'Ticket.pdf\'. They can optionally be based on a template PDF,
and the module just adds the QR code. Additionally, text can be added to
the PDF by this module - either static text or dynamic text based on
[tokens](https://drupal.org/project/token).

This allows, for example, to attach a ticket PDF that contains
submission results such as the table the user chose when filling the
webform. In the
[screenshot](https://www.drupal.org/files/issues/2025-05-25/settings_webform_qr_code_element.png)
you can see an example: the email address from the form is added to the
PDF.

## QR code content

The QR code represents a custom string. As the form author, you decide
what text to put in the QR code - and it depends on how you want the QR
code to be used. QR codes are often URLs, but for this module, the QR
code content doesn't have to be a URL. The content is based on tokens,
so that each submission gets a different value. If used as a valuable
ticket, it should be unique and unguessable to avoid fraud. Examples
are:

-   `[webform_submission:sid]-[webform_submission:created]`
-   `[webform_submission:token]` (a non-guessable pseudo-random string)
-   `[webform_submission:token-view-url]` (the data entered by your
    visitor)

\
Note that there are two distinct concepts called token:

-   The \[\] replacement syntax from the [Token
    module](https://drupal.org/project/token) and
-   the secure pseudo-random string used to look up a webform
    submission, for example
    AqMUTxvL00FOUIIKj-R6vK0mzEflYTVBzWCLVT_gNZ82.

This module also supports multi-line text to be encoded in the QR code,
for example for European banking apps (SEPA credit transfers,
[ECP](https://en.wikipedia.org/wiki/EPC_QR_code))

### How to process the QR code

This module doesn't come with any way to read or process QR codes. In
particular, there is no participant tracking app yet. You need to use
your own. As the data source, you can export webform submissions using
**Results** » **Download**.\
Please [open an
issue](https://www.drupal.org/project/issues/webform_qr_code_element?categories=All)
if you have a publicly available solution. The sponsor of this module,
an event organizer, uses a custom app written by ChatGPT. It is used to
scan the QR code, which looks up the participant. Such an app might just
show a green checkmark if the participant is found.

## Installation

Install the module as you [would normally
install](https://www.drupal.org/node/1897420) a contributed Drupal
module.

## Add a QR code to the email(s) sent by a webform

1.  Go to your webform\'s "Build" tab.

2.  Click on "Add element". Search for "QR Code" (it's in the **Computed
    Elements** section).

3.  Fill all mandatory fields.
    -   **Title** (and key) are just for you internally. They are not
        shown to the participants.
    -   **Text to store in the QR code** needs to be a value that is
        unique for each participant (and event). See examples above in
        the **QR code content** heading. Available tokens can be
        explored at the bottom of the form or on the page /token/tree of
        your Drupal installation.

4.  Go to **Settings » Emails / Handlers** and make sure that the QR
    code is part of the email. Here are example tokens you can add to
    Message » Body:

    -   `[webform_submission:values:html]`
    -   `[webform_submission:qr_code]`

    You should explain why there is a QR code in their email, for
    example like this:

    > Dear \[webform_submission:values:first_name\],\
    > \
    > Thank you for registering for our event! We\'re excited to welcome
    > you and ensure you have a fantastic experience.\
    > \
    > Please note that the following QR code is for the organizers to
    > scan at the event admission. When you arrive, simply present the
    > QR code at the check-in area, and our team will take care of the
    > rest:\
    > \[webform_submission:qr_code\]\
    > \
    > If you have any questions or need further assistance, feel free to
    > reach out to us at *XYZ*.\
    > \
    > We look forward to seeing you at the event!\
    > \
    > Best regards,\
    > *XYZ*

5.  Fill your form, like a participant would, to test how the email
    looks like.

## Maintainer

[Christian "Gogowitsch" Bläul](https://drupal.org/u/gogowitsch). To say
thank-you or financially support development of this module, you can
send a few Euros via PayPal: paypal@blaeul.de
