<?php

/**
 * @file
 * Contains token-specific hooks for the webform_qr_code_element module.
 */

use Drupal\Core\Render\BubbleableMetadata;
use Drupal\webform_qr_code_element\Element\QrCodeElement;

/**
 * Implements hook_token_info().
 *
 * @return \array[][]
 */
function webform_qr_code_element_token_info() {
  $info = [];

  $info['tokens']['webform_submission']['qr_code'] = [
    'name' => t('QR code'),
    'description' => t("Display a QR code"),
  ];

  return $info;
}

/**
 * Implements hook_tokens().
 */
function webform_qr_code_element_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata): array {
  $token_service = Drupal::token();

  if ($type == 'webform_submission' && !empty($data['webform_submission'])) {
    /** @var \Drupal\webform\WebformSubmissionInterface $webform_submission */
    $webform_submission = $data['webform_submission'];

    if (isset($tokens['qr_code'])) {
      $original = $tokens['qr_code'];
      $elements = $webform_submission->getWebform()
        ->getElementsDecodedAndFlattened();
      foreach ($elements as $key => $element) {
        if ($element['#type'] == 'qr_code') {
          return [$original => QrCodeElement::renderImage($webform_submission->getElementData($key), $element)['#markup']];
        }
      }

      return [$original => t('Please add an element of the type “:type” to the form before using this token.', [':type' => t('QR Code')])];
    }
  }

  return [];
}
