<?php

namespace Drupal\webform_registration_handler\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a webform field annotation object.
 *
 * Plugin Namespace: Plugin/WebformUserRegistrationField.
 *
 * @Annotation
 */
class WebformUserRegistrationField extends Plugin {

  /**
   * The plugin plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the field plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $title;

  /**
   * The description of the field plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * Indicates whether the field is required.
   *
   * This property determines if the field is required for user registration.
   *
   * @var bool
   */
  public $isRequired;

  /**
   * Indicates whether the field is updatable.
   *
   * This property determines if the field can be updated after it has been
   * created. Useful for configuration or state changes.
   *
   * @var bool
   */
  public $isFieldUpdatable;

}
