<?php

namespace Drupal\webform_registration_handler\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a webform user registration field attribute object.
 *
 * Plugin Namespace: Plugin/WebformUserRegistrationField.
 *
 * For a working example, see.
 * \Drupal\webform_registration_handler\Plugin\WebformUserRegistrationField\Email.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class WebformUserRegistrationField extends Plugin {

  /**
   * Constructs an archiver plugin attribute object.
   *
   * @param string $id
   *   The archiver plugin ID.
   * @param bool $isRequired
   *   A flag indicating whether the field is required for registration.
   *   Defaults to TRUE.
   * @param bool $isFieldUpdatable
   *   A flag indicating whether the field can be updated after it has been
   *   created. Defaults to FALSE.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $title
   *   The human-readable name of the archiver plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description of the archiver plugin.
   */
  public function __construct(
    public readonly string $id,
    public readonly bool $isRequired = TRUE,
    public readonly bool $isFieldUpdatable = FALSE,
    public readonly ?TranslatableMarkup $title = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
  ) {}

}
