<?php

namespace Drupal\webform_registration_handler;

use Drupal\civicrm\Civicrm;
use Drupal\user\UserInterface;

/**
 * Implements CivicrmManagementInterface for CiviCRM-related operations.
 *
 * This class provides methods to interact with CiviCRM for various operations.
 *
 * @ingroup webform_registration_handler
 */
class CivicrmManagement implements CivicrmManagementInterface {

  /**
   * The CiviCRM service.
   */
  protected ?Civicrm $civicrm;

  /**
   * Constructs a new CivicrmManagement object.
   */
  public function __construct(?Civicrm $civicrm) {
    $this->civicrm = $civicrm;
  }

  /**
   * {@inheritdoc}
   */
  public function synchronizeUfMatch(UserInterface $user) {
    if ($this->civicrm) {
      // @todo set the contact type based on the webform operation.
      $this->civicrm->synchronizeUser($user, 'Individual');
    }
  }

}
