<?php

namespace Drupal\webform_registration_handler;

use Drupal\user\UserInterface;

/**
 * Defines an interface for performing operations related to CiviCRM.
 *
 * This interface provides methods for performing various operations related to
 * CiviCRM, such as synchronizing a CiviCRM contact with a newly created Drupal
 * account.
 *
 * @ingroup webform_registration_handler
 */
interface CivicrmManagementInterface {

  /**
   * Synchronizes a CiviCRM contact with a Drupal user account.
   *
   * This method ensures that a CiviCRM contact is associated with a newly
   * created Drupal user account.
   */
  public function synchronizeUfMatch(UserInterface $user);

}
