<?php

namespace Drupal\webform_registration_handler\Plugin\WebformUserRegistrationField;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\webform_registration_handler\Attribute\WebformUserRegistrationField;
use Drupal\webform_registration_handler\PluginManager\WebformUserRegistrationFieldBase;

/**
 * Provides the webform user registration field for the email.
 *
 * This field maps to the 'mail' field of the user entity.
 */
#[WebformUserRegistrationField(
  id: 'webform_registration_handler_field_email',
  isRequired: TRUE,
  isFieldUpdatable: TRUE,
  title: new TranslatableMarkup('Email'),
  description: new TranslatableMarkup('Webform user registration field for the email.'),
)]
class Email extends WebformUserRegistrationFieldBase {

  /**
   * {@inheritdoc}
   */
  public function getFieldMachineName(): string {
    return 'mail';
  }

}
