<?php

namespace Drupal\webform_registration_handler\Plugin\WebformUserRegistrationField;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\webform_registration_handler\Attribute\WebformUserRegistrationField;
use Drupal\webform_registration_handler\PluginManager\WebformUserRegistrationFieldBase;

/**
 * Provides the webform user registration field for the username.
 *
 * This field maps to the 'name' field of the user entity.
 */
#[WebformUserRegistrationField(
  id: 'webform_registration_handler_field_username',
  isRequired: TRUE,
  isFieldUpdatable: FALSE,
  title: new TranslatableMarkup('Username'),
  description: new TranslatableMarkup('Webform user registration field for the username.'),
)]
class Username extends WebformUserRegistrationFieldBase {

  /**
   * {@inheritdoc}
   */
  public function getFieldMachineName(): string {
    return 'name';
  }

}
