<?php

namespace Drupal\webform_registration_handler\PluginManager;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\webform_registration_handler\Attribute\WebformUserRegistrationField;

/**
 * Provides a webform user registration field plugin manager.
 *
 * @see \Drupal\Core\Archiver\Annotation\Archiver
 * @see \Drupal\Core\Archiver\ArchiverInterface
 * @see plugin_api
 */
class FieldManager extends DefaultPluginManager {

  /**
   * Constructs a ArchiverManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/WebformUserRegistrationField',
      $namespaces,
      $module_handler,
      'Drupal\webform_registration_handler\PluginManager\WebformUserRegistrationFieldInterface',
      WebformUserRegistrationField::class,
      'Drupal\webform_registration_handler\Annotation\WebformUserRegistrationField'
    );
    $this->alterInfo('webform_registration_handler_field_info');
    $this->setCacheBackend($cache_backend, 'webform_registration_handler_field_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function getFieldPlugins(): array {
    $fields = [];
    foreach ($this->getDefinitions() as $id => $definition) {
      $plugin = $this->createInstance($id);
      $fields[$plugin->getPluginId()] = $plugin;
    }
    return $fields;
  }

}
