<?php

namespace Drupal\webform_registration_handler\PluginManager;

use Drupal\Core\Plugin\PluginBase;

/**
 * Base class for Webform user registration field plugins.
 *
 * This class implements common methods for webform user registration fields
 * and provides a structure for field plugins to follow. Field plugins must
 * define their machine name and any specific logic for
 * value processing and validation.
 *
 * @ingroup webform_registration_handler
 */
abstract class WebformUserRegistrationFieldBase extends PluginBase implements WebformUserRegistrationFieldInterface {

  /**
   * The value of the field.
   *
   * @var mixed
   */
  protected mixed $value;

  /**
   * Returns the field machine name.
   *
   * This method must be implemented by each plugin to return the unique
   * machine name of the field.
   */
  abstract public function getFieldMachineName(): string;

  /**
   * {@inheritdoc}
   */
  public function getValue(): mixed {
    return $this->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setValue(mixed $value): void {
    $this->value = $value;
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel(): string {
    return $this->getPluginDefinition()['title'];
  }

  /**
   * {@inheritdoc}
   */
  public function isRequired(): bool {
    return $this->getPluginDefinition()['isRequired'] ?? FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function getProcessedValue(mixed $value): mixed {
    return $value;
  }

  /**
   * {@inheritdoc}
   */
  public function isValueValid(mixed $value): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function isFieldUpdatable(): bool {
    return $this->getPluginDefinition()['isFieldUpdatable'] ?? FALSE;
  }

}
