<?php

namespace Drupal\webform_registration_handler\PluginManager;

/**
 * Defines the interface for the Webform User Registration Field Plugin.
 */
interface WebformUserRegistrationFieldInterface {

  /**
   * Gets the value of the field.
   */
  public function getValue(): mixed;

  /**
   * Sets the value of the field.
   */
  public function setValue(mixed $value): void;

  /**
   * Gets the label for the field.
   */
  public function getLabel(): string;

  /**
   * Determines whether the field is required.
   */
  public function isRequired(): bool;

  /**
   * Processes the value of the field.
   *
   * This method should process the field value before it's used in the
   * submission or saved to the database.
   */
  public function getProcessedValue(mixed $value): mixed;

  /**
   * Validates the value of the field.
   *
   * This method should return whether the value of the field is valid.
   * Custom validation logic should be implemented here.
   */
  public function isValueValid(mixed $value): bool;

  /**
   * Determines if the field value can be updated.
   *
   * This method should return whether the field's value can be updated after
   * initial submission, allowing dynamic fields or post-submission changes.
   */
  public function isFieldUpdatable(): bool;

}
