<?php

namespace Drupal\webform_registration_handler\PluginManager;

/**
 * Provides a service for accessing webform user registration field plugins.
 */
class WebformUserRegistrationFieldProvider {

  /**
   * The field manager.
   */
  protected FieldManager $fieldManager;

  /**
   * Constructs a WebformUserRegistrationFieldProvider object.
   */
  public function __construct(FieldManager $fieldManager) {
    $this->fieldManager = $fieldManager;
  }

  /**
   * Gets all available field plugins.
   */
  public function getFieldPlugins(): array {
    return $this->fieldManager->getFieldPlugins();
  }

  /**
   * Gets a specific field plugin by ID.
   *
   * This method fetches a single field plugin by its unique ID. If the
   * requested plugin ID does not exist, it returns NULL.
   */
  public function getFieldPlugin(string $id): ?WebformUserRegistrationFieldBase {
    $plugins = $this->getFieldPlugins();
    return $plugins[$id] ?? NULL;
  }

}
