<?php

namespace Drupal\webform_registration_handler;

use Drupal\webform\WebformInterface;
use Drupal\webform_registration_handler\PluginManager\WebformUserRegistrationFieldProvider;

/**
 * Provides mapping options for Webform elements to plugin properties.
 *
 * @ingroup webform_registration_handler
 */
class WebformHelper implements WebformHelperInterface {

  /**
   * The Webform user registration field provider.
   *
   * @var \Drupal\webform_registration_handler\PluginManager\WebformUserRegistrationFieldProvider
   */
  protected WebformUserRegistrationFieldProvider $webformUserRegistrationFieldProvider;

  public function __construct(WebformUserRegistrationFieldProvider $webformUserRegistrationFieldProvider) {
    $this->webformUserRegistrationFieldProvider = $webformUserRegistrationFieldProvider;
  }

  /**
   * {@inheritdoc}
   */
  public function getMappingSourceFields(): array {
    $fieldPlugins = $this->webformUserRegistrationFieldProvider->getFieldPlugins();
    $sourceFields = [];

    foreach ($fieldPlugins as $plugin) {
      $sourceFields[$plugin->getPluginId()] = $plugin->getLabel();
    }

    return $sourceFields;
  }

  /**
   * {@inheritdoc}
   */
  public function getRequiredMappingFields(): array {
    $fieldPlugins = $this->webformUserRegistrationFieldProvider->getFieldPlugins();
    $requiredFields = [];

    foreach ($fieldPlugins as $plugin) {
      if (!$plugin->isRequired()) {
        continue;
      }

      $requiredFields[] = $plugin->getPluginId();
    }

    return $requiredFields;
  }

  /**
   * {@inheritdoc}
   */
  public function getMappingDestinationFields(WebformInterface $webform): array {
    $destinationOptions = [];
    $webformElements = $webform->getElementsInitializedFlattenedAndHasValue();

    foreach ($webformElements as $key => $element) {
      $destinationOptions[$key] = $element['#admin_title'] ?: $element['#title'] ?: $key;
    }

    return $destinationOptions;
  }

}
