<?php

namespace Drupal\webform_registration_handler;

use Drupal\webform\WebformInterface;

/**
 * Defines an interface for mapping Webform elements to UserDto properties.
 *
 * This interface provides methods for retrieving mapping options
 * between Webform elements and UserDto properties.
 * It allows you to specify how Webform elements
 * should be mapped to UserDto properties, simplifying the process of creating
 * users based on Webform submissions.
 *
 * @ingroup webform_registration_handler
 */
interface WebformHelperInterface {

  /**
   * Retrieves the mapping destination fields for the given webform.
   *
   * This method returns an array of fields that represent the
   * destination properties in the plugins, mapped from the webform.
   *
   * @param \Drupal\webform\WebformInterface $webform
   *   The webform interface instance.
   *
   * @return array
   *   An array of mapping destination fields.
   */
  public function getMappingDestinationFields(WebformInterface $webform): array;

  /**
   * Retrieves the mapping source fields for plugin properties.
   *
   * This method returns an array of fields that can be used as
   * the source for mapping to plugin properties.
   *
   * @return array
   *   An array of mapping source fields.
   */
  public function getMappingSourceFields(): array;

  /**
   * Retrieves the required mapping fields for plugin properties.
   *
   * This method returns an array of fields that are required
   * for mapping to plugin properties. These fields must be provided
   * to create a UserDto instance successfully.
   *
   * @return array
   *   An array of required mapping fields.
   */
  public function getRequiredMappingFields(): array;

}
