<?php

declare(strict_types=1);

namespace Drupal\Tests\webform_revision_ui\Kernel;

use Drupal\config_revision\Entity\ConfigRevision;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\user\Traits\UserCreationTrait;
use Drupal\webform\Entity\Webform;

/**
 * Tests that revision access permissions .
 */
class WebformRevisionUiAccessTest extends KernelTestBase {

  use UserCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'user',
    'webform',
    'webform_revision_ui',
    'config_revision',
    'system',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    $this->installSchema('webform', ['webform']);
    $this->installSchema('user', ['users_data']);
    $this->installConfig(['webform', 'config_revision']);
    $this->installEntitySchema('webform_submission');
    $this->installEntitySchema('config_revision');
    $this->installEntitySchema('user');
    $config = $this->config('config_revision.settings');
    $config->set('enabled_entity_types', ['webform']);
    $config->save();

    $config_revision_type_storage = \Drupal::service('entity_type.manager')->getStorage('config_revision_type');
    $webform_config_revision_type = $config_revision_type_storage->create([
      'id' => 'webform',
      'label' => 'Webform',
      'description' => '',
    ]);
    $webform_config_revision_type->save();
  }

  /**
   * Tests the webform revisions access.
   */
  public function testWebformRevisionUiAccess(): void {
    $user = $this->createUser(['view all webform revisions']);
    $test_webform = Webform::create([
      'id' => 'test_webform',
      'title' => 'A test form',
    ]);
    $test_webform->setStatus(TRUE);
    $test_webform->save();
    $elements = [
      'root' => [
        '#type' => 'textfield',
        '#title' => 'root',
      ],
    ];
    $test_webform->setElements($elements);
    $test_webform->save();
    // Load the revision by latest revision_id and see if it works.
    $webform_revision = ConfigRevision::loadConfigRevisionByConfigId('test_webform');
    self::assertTrue($webform_revision->access('view', $user));
    self::assertTrue($webform_revision->access('view revision', $user));
    self::assertTrue($webform_revision->access('view all revisions', $user));

    $elements = [
      'root1' => [
        '#type' => 'textfield',
        '#title' => 'root1',
      ],
    ];
    $test_webform->setElements($elements);
    $test_webform->save();
    $user1 = $this->createUser(['revert all webform revisions']);

    // Load the revision by latest revision_id and see if it works.
    $webform_revision->isDefaultRevision(FALSE);
    $webform_revision2 = ConfigRevision::loadConfigRevisionByConfigId('test_webform');
    $webform_revision2->isDefaultRevision(TRUE);
    // Revert the non-default revision.
    self::assertTrue($webform_revision->access('revert', $user1));

    $user2 = $this->createUser(['delete all webform revisions', 'administer config_revision']);
    self::assertTrue($webform_revision->access('delete revision', $user2));
  }

}
