<?php

namespace Drupal\webform_simplify\Plugin\WebformSimplifyElement;

/**
 * Defines the Webform Search element.
 *
 * @WebformSimplifyElement(
 *     id = "search",
 *     label = @Translation("Search"),
 *     provider = "webform",
 * )
 * @see \Drupal\webform\Plugin\WebformElement\Search
 */
class Search extends TextBase {

  /**
   * {@inheritdoc}
   */
  public function getFeatures(): array {
    $features = parent::getFeatures();
    unset($features['display']);

    return $features;
  }

  /**
   * {@inheritdoc}
   */
  public function getFeaturePropertyMap(): array {
    $map = parent::getFeaturePropertyMap();
    unset($map['display']);

    return $map;
  }

}
