<?php

namespace Drupal\webform_simplify;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Hide certain parts of Webform submissions settings.
 */
class WebformAccessSettingsAlter {

  /**
   * WebformSettingsAlter constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Hides certain parts of webform access forms.
   *
   * @param array $form
   *   The form render array.
   */
  public function alter(array &$form): void {
    if (webform_simplify_can_bypass()) {
      return;
    }

    $config = $this->configFactory->get('webform_simplify.settings');

    $disabledAccessRoles = $config->get('webform_settings.disabled_access_roles_settings') ?? [];
    if ($disabledAccessRoles !== []) {
      foreach ($form['access'] as &$formAccess) {
        if (!is_array($formAccess) || !array_key_exists('roles', $formAccess)) {
          continue;
        }

        $formAccess['roles']['#type'] = 'webform_simplify_roles';
      }
    }

    $disabledAccessesAutocomplete = $config->get('webform_settings.disabled_access_autocomplete_settings') ?? [];
    if ($disabledAccessesAutocomplete !== []) {
      foreach ($form['access'] as &$formAccess) {
        if (!is_array($formAccess)) {
          continue;
        }

        foreach ($disabledAccessesAutocomplete as $disabledAccessAutocomplete) {
          if (array_key_exists($disabledAccessAutocomplete, $formAccess)) {
            $formAccess[$disabledAccessAutocomplete]['#access'] = FALSE;
          }
        }
      }
    }

    $disabledAccesses = $config->get('webform_settings.disabled_access_settings') ?? [];
    if ($disabledAccesses !== []) {
      foreach ($disabledAccesses as $disabledAccess) {
        $form['access'][$disabledAccess]['#access'] = FALSE;
      }
    }

  }

}
