# Webform Statistics

## Introduction
Webform Statistics is a Drupal module that provides comprehensive analytics and reporting capabilities for webform submissions. It extends the Webform module by adding a dedicated "Statistics" tab to the webform submissions management page, allowing site administrators to easily monitor and analyze form submission data.

## Features
- Real-time tracking of submission counts for each webform
- Advanced statistics filterable by customizable date ranges
- Detailed information including latest submission timestamps
- Seamless integration with Drupal Views for creating custom reports
- Performance-optimized for sites with large numbers of submissions
- User-friendly interface for data visualization

## Requirements
- Drupal 9 or 10
- Webform module (version 6.x recommended)
- Views module (core)

## Installation
1. Download and place the module in your `/modules/custom` directory
2. Enable the module via the Extend interface or using Drush:
   ```
   drush en webform_statistics
   ```
3. Clear caches after installation:
   ```
   drush cr
   ```

## Usage
After installation and configuration, the module provides:

1. A new "Statistics" tab at `/admin/structure/webform/submissions/manage/statistics`
2. A dashboard displaying key metrics:
  - Form Name
  - Latest Submission Date and Time
  - Total Submission Count

You can filter statistics by date range to analyze submission patterns and user engagement over specific time periods.

## Configuration
No additional configuration is required after installation.

## Permissions
The module provides the following permission:
- "Access webform statistics": Controls access to the statistics dashboard. This permission should be granted to administrative roles that need to view and analyze submission data.
 the Views UI. Advanced users can create additional views-based displays or extend the module's functionality through custom code.

## Support
For bug reports or feature requests, please use the project's issue queue.
