<?php

namespace Drupal\webform_statistics\Plugin\views\field;

use Drupal\views\Plugin\views\field\Date;
use Drupal\Core\Datetime\Entity\DateFormat;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Allow to group by creation date of webform submission.
 *
 * @ViewsField("created_groupable")
 */
class WebformSubmissionCreatedGroupable extends Date {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->ensureMyTable();
    $params = [];
    $format = $this->getFormat();
    // Fix week format.
    if ($format === 'Y-\WW') {
      $format = 'Y-W';
    }
    $format_date = $this->query->getDateFormat("FROM_UNIXTIME(created)", $format);
    $this->field_alias = $this->query->addField('', $format_date, $this->tableAlias . '_created', $params);
    $this->addAdditionalFields();
  }

  /**
   * Get the configured date format.
   *
   * @return string
   *   The date format.
   */
  protected function getFormat() {
    $format = $this->options['date_format'] ?? '';
    if ($format === 'custom') {
      return $this->options['custom_date_format'] ?? '';
    }
    if ($format) {
      $formatter = DateFormat::load($format);
      return $formatter ? $formatter->getPattern() : '';
    }
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $value = $this->getValue($values);
    // We need to make some magic to convert the date format to a week format.
    if ($this->options['date_format'] === 'html_week') {
      $value = str_replace('-', '-W', $value);
      return $this->sanitizeValue($value);
    }
    return FieldPluginBase::render($values);
  }

}
