<?php

namespace Drupal\webform_statistics\Plugin\views\field;

use Drupal\views\Plugin\views\field\Date;

/**
 * Field handler to display the latest submission date for a webform.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("webform_latest_submission_date")
 */
class WebformLatestSubmissionDate extends Date {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $alterableField = 'created';
    $this->ensureMyTable();
    // Add the field.
    $params = ['function' => 'max'];
    $this->field_alias = $this->query->addField($this->tableAlias, $alterableField, NULL, $params);
    $this->addAdditionalFields();
  }

}
