(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.webformSubmitTimer = {
    attach: function (context, settings) {
      $('form.webform-submission-form', context).each(function () {
        const $form = $(this);

        // Prevent multiple runs
        if ($form.data('submit-timer-applied')) return;
        $form.data('submit-timer-applied', true);

        const formId = $form.attr('id');
        const timerSettings = drupalSettings.webformSubmitTimer?.[formId];
        if (!timerSettings || !timerSettings.timer) return;

        let seconds = parseInt(timerSettings.timer);
        const $submit = $form.find('input[type=submit], button[type=submit]');
        const $countSpan = $form.find('.webform-timer-count');
        const $message = $form.find('.webform-submit-timer-message');

        $submit.prop('disabled', true);

        const countdown = setInterval(() => {
          seconds--;

          if ($countSpan.length) {
            $countSpan.text(seconds);
          }

          if (seconds <= 0) {
            clearInterval(countdown);
            $submit.prop('disabled', false);
            if ($message.length) {
              $message.text('Webform is ready to submit.');
            }
          }
        }, 1000);

      });
    }
  };
})(jQuery, Drupal, drupalSettings);
