<?php

namespace Drupal\webform_submit_timer\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Entity\Webform;

/**
 *
 */
class WebformSubmitTimerSettingsForm extends ConfigFormBase {

  /**
   *
   */
  protected function getEditableConfigNames() {
    return ['webform_submit_timer.settings'];
  }

  /**
   *
   */
  public function getFormId() {
    return 'webform_submit_timer_settings_form';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('webform_submit_timer.settings');

    $form['timers'] = [
      '#type' => 'details',
      '#title' => $this->t('Webform Submit Timers'),
      '#open' => TRUE,
      '#tree' => TRUE,
    ];

    // Load all webforms.
    $webforms = Webform::loadMultiple();

    foreach ($webforms as $id => $webform) {
      $form['timers'][$id] = [
        '#type' => 'number',
        '#title' => $webform->label(),
        '#default_value' => $config->get("timers.$id") ?? 0,
        '#description' => $this->t('Timer in seconds before submit button becomes active. Set 0 for no delay.'),
        '#min' => 0,
      ];
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->config('webform_submit_timer.settings');

    $values = $form_state->getValue('timers') ?? [];

    foreach ($values as $key => $value) {
      $config->set("timers.$key", $value);
    }

    $config->save();

    parent::submitForm($form, $form_state);
  }

}
