# Webform Yuboto SMS Handler

A Drupal module that provides a Webform handler to send SMS messages using the Yuboto SMS API.
See more at the [Yuboto Messaging Platform](https://messaging.yuboto.com).
The latest Yuboto API version tested with this module is `v1.10` (as of 2025-12-06).

## Features

- Send SMS messages to webform submission phone numbers
- Configurable message templates with token support
- Global API key configuration through Drupal UI
- Support for custom sender names
- Comprehensive error handling and logging

## Requirements

- Drupal 9, 10, or 11
- Webform module
- Yuboto SMS API account and API key

## Configuration

### 1. Configure API Keys

Navigate to **Administration > Configuration > Services > Yuboto SMS Settings** (`/admin/config/services/webform-yuboto`):

**Note**: Access to this configuration page requires the "Administer Webform Yuboto SMS settings" permission, which should be granted to trusted administrators only.

**Environment Control**:
- The enable/disable toggle allows you to temporarily disable SMS sending without uninstalling the module, perfect for staging environments
- The debug mode toggle provides different error handling behaviors for development vs. production environments

**Phone Number Validation**:
The module automatically validates and normalizes Greek mobile phone numbers:
- Only accepts Greek mobile numbers starting with `69`
- 10-digit numbers (`6912345678`) are automatically prefixed with `30`
- 12-digit numbers with country code (`306912345678`) are accepted as-is
- All normalized phone numbers use the format `3069XXXXXXXX` (without + prefix)
- Invalid numbers are rejected and logged but don't interrupt form submission (unless debug mode is enabled)

### 2. Configure Webform Handler

1. Edit your webform
2. Go to **Settings > Handlers > Add handler**
3. Select **Yuboto SMS** from the list
4. Configure the handler settings:
   - **Phone number field**: Select the form field that contains the phone number
   - **SMS Message**: Enter the message to send (supports tokens) or leave to use the default
   - **Sender Name**: Enter the sender name for the SMS or leave to use the default

## Token Support

You can use the following tokens in your message and sender fields:

- **Webform tokens**: `[webform:title]`, `[webform:id]`
- **Submission tokens**: `[webform_submission:value:field_name]`, `[webform_submission:serial]`
- **Site tokens**: `[site:name]`, `[site:slogan]`, `[current-user:name]`
- **Global tokens**: `[current-date:custom:Y-m-d]`, etc.

## API Request Format

The module sends requests to Yuboto API using **Basic Authentication** with your API key as the Basic auth credentials.

**HTTP Request Format:**
- **Method**: POST
- **URL**: `https://services.yuboto.com/omni/v1/Send`
- **Headers**:
  ```
  Content-Type: application/json; charset=utf-8
  Accept: application/json
  Authorization: Basic <base64_encoded_api_key>
  ```

**Request Body:**
```json
{
  "dir": "false",
  "contacts": [
    {
      "phonenumber": "3069XXXXXXXX"
    }
  ],
  "sms": {
    "sender": "[site:name]",
    "text": "Thank you for your submission",
    "validity": 1440,
    "typesms": "sms",
    "long_sms": false,
    "priority": 1
  }
}
```

## Debug Mode

Use the debug mode setting to control error handling behavior:

- **Development/Testing**: Enable debug mode to see exceptions immediately and identify issues
- **Production**: Keep debug mode disabled to ensure form submissions complete even if SMS sending fails

### Common Issues

1. **API Key not configured**: Ensure you've entered your Yuboto API key in the settings
2. **Phone number field empty**: Make sure the selected phone field contains valid phone numbers
3. **Invalid Greek mobile number**: Phone numbers must be Greek mobile numbers starting with 69
4. **Invalid phone format**: The module accepts:
   - 10-digit Greek mobile numbers (e.g., `6912345678`) - automatically adds 30 prefix
   - 12-digit numbers with country code (e.g., `306912345678`)
   - All numbers are normalized to `3069XXXXXXXX` format (without + prefix)
5. **Non-Greek numbers**: Only Greek mobile numbers (69 prefix) are accepted
6. **Sender name too long**: Sender names must be 11 characters or less

## Development

### Extending the Module

You can extend the module by:

1. **Hook Implementation**: Use `hook_webform_yuboto_sms_data()` to alter API requests before sending
2. **Custom Validation**: Add validation in the API service or handler
3. **Token Replacements**: Implement additional token replacements for message customization
4. **Configuration Options**: Add more configuration options to the handler
5. **SMS Providers**: Create additional SMS providers or integrations

### Hooks

```php
/**
 * Implements hook_webform_yuboto_sms_data().
 */
function mymodule_webform_yuboto_sms_data(&$sms_data, $context) {
  // Alter SMS data before sending to the API...
}
```

See [webform_yuboto.api.php](webform_yuboto.api.php) for detailed hook documentation.

## Future plans

- Add testing
- Add GitLab CI pipeline
- Add info on System status page
- Add support for webform submission with multiple phone numbers
- Check all the webform submission tokens get replaced on the API call
- Extend the API to support Viber
- Extend the API to support more API call verbs (not only Send)
- Consider splitting the Yuboto API to a standalone module
