<?php
require_once(__DIR__.'/standalone_token.php');

function wediaTokenGeneratorTokenize($url, $tokenSecretKey, $window)
{
  $timestamp = time();
  $tokenParameterName = 'RequestToken';
  $path = parse_url($url, PHP_URL_PATH);

  $query = parse_url($url, PHP_URL_QUERY);

  $acl = $query ? $path.'?'.$query.'*' : $path.'*';

  $c = new Akamai_EdgeAuth_Config();
  $g = new Akamai_EdgeAuth_Generate();
  $c->set_window($window);
  $c->set_start_time($timestamp);
  $c->set_acl($acl);
  $c->set_algo("sha256");
  $c->set_key($tokenSecretKey);
  $token = $g->generate_token($c);

  $url = trim($url, '?');
  if(strpos($url, "?") === false)
  {
    $returnUrl = sprintf("%s?%s=%s", $url, $tokenParameterName, urlencode($token));
  }else{
    $returnUrl = sprintf("%s&%s=%s", $url, $tokenParameterName, urlencode($token));
  }
  return $returnUrl;
}

$tokenizedUrl = null;

if(array_key_exists("inputUrl", $_POST))
{
  $inputUrl = trim($_POST['inputUrl']);
  $akamaiSecretTokenKey = trim($_POST['akamaiSecretTokenKey']);
  $window = trim($_POST['window']);
  if (!$window) { $window = 7200; }
  $options = array(
    'akamaiSecret'=>$akamaiSecretTokenKey,
  );
  $tokenizedUrl = wediaTokenGeneratorTokenize($inputUrl, $akamaiSecretTokenKey, $window, $options);
}

?>
<html class="h-full">
<head>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/@tailwindcss/forms/dist/forms.min.css" rel="stylesheet">
  </head>
<body class="h-full">
<div class="min-h-full">
    <nav class="bg-white border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex">
                    <div class="flex-shrink-0 flex items-center">
                        <img class="hidden lg:block h-8 w-auto" src="https://www-cdn2.wedia-group.com/wp-content/uploads/2018/03/wedia2017blue.png" alt="Wedia">
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <div class="py-10">
        <header>
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h1 class="text-3xl font-bold leading-tight text-gray-900">
                    Sample Tokenization Screen
                </h1>
            </div>
        </header>
        <main>
            <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
                <div class="px-4 py-8 sm:px-0">
                    <div class="h-96">
                        <form class="space-y-8 divide-y divide-gray-200" method="POST">
                            <div class="space-y-8 divide-y divide-gray-200 sm:space-y-5">
                                <div>
                                    <h3 class="text-lg leading-6 font-medium text-gray-900">
                                        Tokenize a video
                                    </h3>
                                    <p class="mt-1 max-w-2xl text-sm text-gray-500">
                                        Insert an url code generated by Wedia to get the tokenized url back. Do not use the embed code.
                                    </p>
                                </div>

                                <div class="mt-6 sm:mt-5 space-y-6 sm:space-y-5">
                                    <div class="sm:grid sm:grid-cols-3 sm:gap-4 sm:items-start sm:border-t sm:border-gray-200 sm:pt-5">
                                        <label for="akamaiSecretTokenKey" class="block text-sm font-medium text-gray-700 sm:mt-px sm:pt-2">
                                            Secret token
                                        </label>
                                        <div class="mt-1 sm:mt-0 sm:col-span-2">
                                            <div class="max-w-lg flex rounded-md shadow-sm">
                                              <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
                                                Token code
                                              </span>
                                              <input type="text" name="akamaiSecretTokenKey" id="akamaiSecretTokenKey"  class="flex-1 block w-full focus:ring-indigo-500 focus:border-indigo-500 min-w-0 rounded-none rounded-r-md sm:text-sm border-gray-300">
                                            </div>
                                            <p class="mt-2 text-sm text-gray-500">The token that you got from your Wedia Account Manager.</p>
                                            <p class="mt-2 text-sm text-gray-200">91dbb5441d3f9a53fef177a5cede431767b319c35af68b0f36ebee190267fdb4</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-6 sm:mt-5 space-y-6 sm:space-y-5">
                                    <div class="sm:grid sm:grid-cols-3 sm:gap-4 sm:items-start sm:border-t sm:border-gray-200 sm:pt-5">
                                        <label for="window" class="block text-sm font-medium text-gray-700 sm:mt-px sm:pt-2">
                                            Time window
                                        </label>
                                        <div class="mt-1 sm:mt-0 sm:col-span-2">
                                            <div class="max-w-lg flex rounded-md shadow-sm">
                                                <input type="text" name="window" id="window" value="10" class="flex-1 block w-full focus:ring-indigo-500 focus:border-indigo-500 min-w-0 rounded-none rounded-r-md sm:text-sm border-gray-300">
                                            </div>
                                            <p class="mt-2 text-sm text-gray-500">The time window, in seconds, of the token validity.</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="sm:grid sm:grid-cols-3 sm:gap-4 sm:items-start sm:border-t sm:border-gray-200 sm:pt-5">
                                    <label for="inputUrl" class="block text-sm font-medium text-gray-700 sm:mt-px sm:pt-2">
                                        Non-Tokenized URL
                                    </label>
                                    <div class="mt-1 sm:mt-0 sm:col-span-2">
                                        <textarea id="inputUrl" name="inputUrl" rows="6" class="max-w-lg shadow-sm block w-full focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border border-gray-300 rounded-md p-4">https://mediacloudapi-cea.azurewebsites.net/api/media/play.html?PlayerUid=h5c530c2c88b87&MediaUid=e1f3d583-d29e-4cae-b7ab-6f3ad1552477&Autostart=false&Share=false</textarea>
                                        <p class="mt-2 text-sm text-gray-500">Paste here the non-tokenized video URL.</p>
                                    </div>
                                </div>

                                <div class="pt-5">
                                    <div class="flex justify-end">
                                        <button type="submit" class="ml-3 inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                            Tokenize
                                        </button>
                                    </div>
                                </div>

                                <?php if($tokenizedUrl): ?>
                                    <div class="sm:grid sm:grid-cols-3 sm:gap-4 sm:items-start sm:border-t sm:border-gray-200 sm:pt-5">
                                        <label for="tokenizedUrl" class="block text-sm font-medium text-gray-700 sm:mt-px sm:pt-2">
                                            Tokenized URL
                                            <a href="<?php echo str_replace('"', '\"', $tokenizedUrl); ?>" target="_blank"
                                               class="block text-sm mt-3 mb-4 underline decoration-sky-500 decoration-2">Click to open in a new window</a>
                                        </label>
                                        <div class="mt-1 sm:mt-0 sm:col-span-2">
                                            <textarea id="tokenizedUrl" name="tokenizedUrl" rows="8"
                                                      class="max-w-lg shadow-sm bg-indigo-100 block w-full focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm border border-gray-300 rounded-md p-4"><?php echo str_replace('"', '\"', $tokenizedUrl); ?></textarea>

                                        </div>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
<div>


</div>
</body>
</html>