# WissKI Authority Document

## Overview
The WissKI Authority Document module provides integration with authority document services for the WissKI system. It enables autocompletion functionality that can fetch data from various authority sources like GND (Gemeinsame Normdatei), Getty Vocabularies, and GeoNames.

## Features
- Autocomplete integration with authority document services
- Support for multiple authority sources:
  - GND (Gemeinsame Normdatei)
  - Getty Vocabularies (placeholder implementation)
  - GeoNames (placeholder implementation)
  - Custom WissKI sources
- Field widget for easy integration with Drupal fields
- Configurable API settings

## Requirements
- Drupal 11
- WissKI Autocomplete module (part of [WissKI](https://www.drupal.org/project/wisski))

## Installation
1. Go to `/admin/modules` and install `WissKI Authority Document` or use `drush en wisski_authority_document`.

## Configuration
Navigate to `/admin/config/wisski/authority-document` to configure the module settings.

### Global Settings
- **GND Settings**:
  - API URL (default: https://services.dnb.de/sru/authorities)
- **Getty Vocabularies** (placeholder implementation)
- **GeoNames** (placeholder implementation)

## Field Integration
The module provides a field widget called "Authority Document Autocomplete" which can be used with string or link field types.

### Setting Up Fields
1. Add a string or link field to your entity type
2. Select "Authority Document Autocomplete" as the widget
3. Configure the widget settings.

### Field Widget Settings
When configuring the Authority Document Autocomplete widget, you need to define the following settings:

- **Authority Type Field ID**: The field ID where the authority type is stored (e.g., `field__auth_doc__authority_type`).
  + Needs to be a "List (text)" field, "Check boxes/ radio buttons" widget, "Cardinality" of "1" with key-value pairs: "Custom|custom", "GND|gnd", "Getty|getty", "Geonames|geonames". Make it "Required field", with "Default value" to "GND".
- **Entity Type Field ID**: Optional field ID to restrict autocomplete suggestions to specific entity types.
  + Needs to be a "List (text)" field, "Check boxes/ radio buttons" widget, "Cardinality" of "1" with key-value pairs: "Körperschaft|Tb", "Kongress|Tf", "Person|Tp", "Sachbegriff|Ts", and "Werk|Tu". Make it "Required field", with "Default value" to "GND".
- **Link Field ID**: The field ID where links will be stored (e.g., `field__auth_doc__link`).
  + Set "Allow link text" to "Disabled", because we don't need it.
- **Minimum characters**: The minimum number of characters required to trigger autocomplete (default: 3).

## Usage
Once configured, the autocomplete field will allow users to search external authority documents by typing at least the minimum number of characters. The system will query the configured authority services and present matching results to the user.

### Supported Authority Types
- `gnd`: German National Library's Integrated Authority File
- `getty`: Getty Vocabularies (placeholder implementation)
- `geonames`: GeoNames geographical database (placeholder implementation)
- `custom`: Custom WissKI sources (local storage)

## Developers
The module provides JavaScript and CSS that are automatically attached to the autocomplete fields. You can extend the functionality by implementing additional authority document providers.

## Troubleshooting
- Ensure your API endpoints are correctly configured
- Check browser console for JavaScript errors
- Verify network connectivity to external authority sources
- Make sure you have at least 3 characters (or your configured minimum) before autocomplete triggers

## Credits
Developed as part of the WissKI project (http://wiss-ki.eu/).
