<?php

namespace Drupal\wisski_authority_document\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Authority Document settings.
 */
class AuthorityDocumentSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'wisski_authority_document.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'authority_document_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('wisski_authority_document.settings');

    $form['custom_terms'] = [
      '#type' => 'details',
      '#title' => $this->t('Custom Terms'),
      '#open' => TRUE,
      '#tree' => TRUE,
    ];

    $form['custom_terms']['custom_terms_bundle'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Custom Terms Bundle'),
      '#description' => $this->t('Enter the bundle name for the custom terms.'),
      '#default_value' => $config->get('custom_terms')['custom_terms_bundle'] ?: 'custom_terms_bundle',
    ];

    $form['custom_terms']['custom_terms_preferred_name_field'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Preferred Name Field'),
      '#description' => $this->t('Enter the field id for the preferred name.'),
      '#default_value' => $config->get('custom_terms')['custom_terms_preferred_name_field'] ?: 'field__auth_doc__custom_terms_preferred_name',
    ];

    $form['custom_terms']['custom_terms_alternative_name_field'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Alternative Name Field'),
      '#description' => $this->t('Enter the field id for the alternative name.'),
      '#default_value' => $config->get('custom_terms')['custom_terms_alternative_name_field'] ?: 'field__auth_doc__custom_terms_alternative_name',
    ];

    $form['custom_terms']['custom_terms_max_results'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum Results'),
      '#description' => $this->t('Maximum number of results to return for autocomplete.'),
      '#default_value' => $config->get('custom_terms')['custom_terms_max_results'] ?: 10,
      '#min' => 1,
      '#max' => 50,
      '#required' => TRUE,
    ];

    $form['gnd'] = [
      '#type' => 'details',
      '#title' => $this->t('GND Settings'),
      '#open' => TRUE,
      '#tree' => TRUE,
    ];

    $form['gnd']['gnd_api_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('GND API URL'),
      '#description' => $this->t('The URL for the GND API.'),
      '#default_value' => $config->get('gnd')['gnd_api_url'] ?: 'https://services.dnb.de/sru/authorities',
      '#required' => TRUE,
    ];

    $form['gnd']['gnd_max_results'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum Results'),
      '#description' => $this->t('Maximum number of results to return for autocomplete.'),
      '#default_value' => $config->get('gnd')['gnd_max_results'] ?: 10,
      '#min' => 1,
      '#max' => 50,
      '#required' => TRUE,
    ];

    $form['getty'] = [
      '#type' => 'details',
      '#title' => $this->t('Getty Vocabularies Settings (Dummy)'),
      '#open' => FALSE,
      '#tree' => TRUE,
    ];

    $form['getty']['getty_api_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Getty API URL'),
      '#description' => $this->t('The URL for the Getty API.'),
      '#default_value' => $config->get('getty')['getty_api_url'] ?: 'https://data.getty.edu/vocab/sparql',
    ];

    $form['getty']['getty_max_results'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum Results'),
      '#description' => $this->t('Maximum number of results to return for autocomplete.'),
      '#default_value' => $config->get('getty')['getty_max_results'] ?: 10,
      '#min' => 1,
      '#max' => 50,
      '#required' => TRUE,
    ];

    $form['geonames'] = [
      '#type' => 'details',
      '#title' => $this->t('GeoNames Settings (Dummy)'),
      '#open' => FALSE,
      '#tree' => TRUE,
    ];

    $form['geonames']['geonames_api_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('GeoNames API URL'),
      '#description' => $this->t('The URL for the GeoNames API.'),
      '#default_value' => $config->get('geonames')['geonames_api_url'] ?: 'https://api.geonames.org/searchJSON',
    ];

    $form['geonames']['geonames_max_results'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum Results'),
      '#description' => $this->t('Maximum number of results to return for autocomplete.'),
      '#default_value' => $config->get('geonames')['geonames_max_results'] ?: 10,
      '#min' => 1,
      '#max' => 50,
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('wisski_authority_document.settings')
      ->set('custom_terms', $form_state->getValue('custom_terms'))
      ->set('gnd', $form_state->getValue('gnd'))
      ->set('getty', $form_state->getValue('getty'))
      ->set('geonames', $form_state->getValue('geonames'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
