<?php

namespace Drupal\wisski_core\Entity;

use Drupal\wisski_pathbuilder\Entity\WisskiPathbuilderEntity;
use Drupal\wisski_salz\Entity\Adapter;
use Drupal\wisski_pathbuilder\Entity\WisskiPathEntity;
use Drupal\wisski_salz\AdapterHelper;
use Drupal\Core\Link;
use Drupal\Core\Config\Entity\ConfigEntityBundleBase;
use Drupal\wisski_core\WisskiBundleInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Language\LanguageInterface;

use Drupal\wisski_core\WisskiCacheHelper;
use Drupal\menu_link_content\Entity\MenuLinkContent;
use Drupal\views\Entity\View;

use Drupal\Core\Entity\EntityStorageInterface;
/**
 * Defines the bundle configuration entity.
 *
 * @ConfigEntityType(
 *   id = "wisski_bundle",
 *   label = @Translation("Wisski Bundle"),
 *	 fieldable = FALSE,
 *   handlers = {
 *     "view_builder" = "Drupal\wisski_core\WisskiEntityViewBuilder",
 *     "form" = {
 *       "add" = "Drupal\wisski_core\Form\WisskiBundleForm",
 *       "edit" = "Drupal\wisski_core\Form\WisskiBundleForm",
 *			 "delete" = "Drupal\wisski_core\Form\WisskiBundleDeleteForm",
 *       "title" = "Drupal\wisski_core\Form\WisskiTitlePatternForm",
 *			 "delete_title" = "Drupal\wisski_core\Form\WisskiTitlePatternDeleteForm",
 *     },
 *     "list_builder" = "Drupal\wisski_core\Controller\WisskiBundleListBuilder",
 *     "access" = "Drupal\wisski_core\Controller\WisskiBundleAccessHandler",
 *   },
 *   admin_permission = "administer wisski_core",
 *   config_prefix = "wisski_bundle",
 *   config_export = {
 *     "id",
 *     "label",
 *     "description",
 *     "title_pattern",
 *     "on_empty",
 *     "fallback_title",
 *     "pager_limit",
 *     "menu_items",
 *   },
 *
 *   bundle_of = "wisski_individual",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "description" = "description",
 *   },
 *   links = {
 *     "edit-form" = "/admin/structure/wisski_core/{wisski_bundle}/edit",
 *     "delete-form" = "/admin/structure/wisski_core/{wisski_bundle}/delete",
 *     "entity-list" = "/wisski/navigate/{wisski_bundle}",
 *     "list" = "/admin/structure/wisski_core",
 *     "title-form" = "/admin/structure/wisski_core/{wisski_bundle}/title",
 *     "delete-title-form" = "/admin/structure/wisski_core/{wisski_bundle}/delete-title",
 *   }
 * )
 */
class WisskiBundle extends ConfigEntityBundleBase implements WisskiBundleInterface {

  use StringTranslationTrait;

  /** constants to identify empty title reaction types */
  const DONT_SHOW = 1;
  const FALLBACK_TITLE = 2;
  const DEFAULT_PATTERN = 3;

  const MENU_CREATE = 1;
  const MENU_ENABLE = 2;

  /**
   * A pb cache because loading is pain
   */
  protected $pb_cache = array();

  /**
   * An adapter cache because loading is pain!
   */
  protected $adapter_cache = array();

  /**
   * The field based pattern for the entity title generation.
   * A serialized array.
   * @var string
   */
  protected $title_pattern = '';

  /**
   * The way in which to react on the detection of an invalid title
   * defaults to fallback title
   */
  protected $on_empty = self::DEFAULT_PATTERN;

  /**
   * The fallback title that may be shown when an entity title cannot be resolved
   */
  protected $fallback_title = 'WissKI Entity';

  /**
   * The pager limit for the bundle based entity list
   */
  protected $pager_limit = 10;

  /**
   * The options array for this bundle's title pattern
   */
  protected $path_options = array();


  protected $menu_items = array();

  /**
   * Where should this be listed?
   * @return array with key = menu name
   *         and value route parameters
   */
  public static function getWissKIMenus() {
    return array('navigate' => 'entity.wisski_bundle.entity_list',
                 'create' => 'entity.wisski_individual.add');
  }

  public static function postDelete(EntityStorageInterface $storage, array $entities) {
    parent::postDelete($storage, $entities);

#    $menus = array("navigate" => 'entity.wisski_bundle.entity_list', "create" => 'entity.wisski_individual_create.list');

    foreach($entities as $entity) {
      $menus = $entity->getWissKIMenus();
      foreach($menus as $menu_name => $route) {
        $entity->deleteBundleFromMenu($menu_name,  $route);
      }
    }
  }

  public function getTitlePattern() {

    if(empty($this->title_pattern)) {

      $state = \Drupal::state()->get('wisski_core_title_patterns') ?: serialize(array());
      $state = unserialize($state);

      $title = isset($state[$this->id]) ? $state[$this->id] : '';

      if(!empty($title))
        return $title;
# This might be annoying
#      else
#        \Drupal::messenger()->addStatus('Could not create Title for Bundle ' . $this->id . '. Please resave the title pattern');
    }

    return unserialize($this->title_pattern);

  }

  public function removeTitlePattern() {

    if ('' !== $this->title_pattern) {
      $this->title_pattern = '';
      $this->flushTitleCache();
    }
  }

  public function getDefaultPattern() {

    return \Drupal::config('wisski_core.settings')->get('wisski_default_title_pattern');
  }

  protected $cached_titles;

  public function generateEntityTitle($entity,$include_bundle=FALSE,$force_new=FALSE) {
#    dpm(serialize($entity), "what?");
#    dpm(microtime(), "begin title");
    $pattern = $this->getTitlePattern();
#    dpm("Pattern is " . serialize($pattern));
    // reduce to the id because for historical reasons...
    if(is_object($entity))
      $entity_id = $entity->id();
    else
      $entity_id = $entity;

#      dpm("get title for $entity");

#  dpm(serialize($entity), "yay");

    if(is_object($entity))
      $language = $entity->language()->getId();
    else
      $language = \Drupal::service('language_manager')->getCurrentLanguage()->getId();
#    dpm($language, "language?");

    #drupal_set_message(serialize($pattern));
    #drupal_set_message("generated: " . $this->applyTitlePattern($pattern,$entity_id));
#    dpm([$pattern, $entity_id], "eid!");
#    dpm(serialize($force_new), "force new?");
#    dpm("you are asking me for $entity_id in language $language");
#    $force_new = true;
    if (!$force_new) {
      $title = $this->getCachedTitle($entity_id);
 #     dpm( "got cached title " . serialize($title) . "for entity $entity with pattern " . serialize($pattern));
#      $title = NULL;
      if (isset($title)) {
        #drupal_set_message('Title from cache');
        if ($include_bundle) {
          \Drupal::messenger()->addStatus('Enhance Title '.$title);
          $title = $this->label().': '.$title;
        }
#        dpm("ret");
        return $title;
      }
    }

#    dpm([$pattern, $entity_id], "eid!");

    $pattern = $this->getTitlePattern();

    //now do the work
    $title = $this->applyTitlePattern($pattern,$entity);
#    return "yay?";
#   dpm($title);

     // TODO: repair this after translation update...
     // this needs to be serialized
    if(!empty($entity_id))
      $this->setCachedTitle($entity_id, $title);

    if ($include_bundle && $title !== FALSE) {
      \Drupal::messenger()->addStatus('Enhance Title '.$title);
      $title = $this->label().': '.$title;
      # TODO: here we have to include the language
    }

#    dpm(microtime(), "generated title $title");

#    dpm(microtime(), "end title");
    if (is_object($entity)) {
	    if(isset($title[$language])) {
		    return $title[$language];
	    } else {
		    return reset($title);
	    }
    }

#    foreach($title as $lang => $aTitle) {
#      if($lang == $language) {
#        unset($title[$lang]);
#        $title["x-default"] = $aTitle;
#      }
#    }

#    return array("x-default" => "mien", "ar" => "ara");

#      unset($title[$language]);
#      $title[LanguageInterface::LANGCODE_DEFAULT] = $the_real_title;
#    }
#    dpm($title, "tit2?");
#    return "yay?";
    return $title;
  }

  /**
   * Applies the title pattern to generate the entity title,
   * this is a seperate function since we want to be able to apply it again in case we end up with an empty title
   */
  private function applyTitlePattern($pattern,$entity) {

    $available_languages = \Drupal::languageManager()->getLanguages();
    $available_languages = array_keys($available_languages);

    // here we store if any path part is given for a certain language.
    $has_any_path_part_per_language = array();

#    dpm("apply");
#    dpm(microtime(), "apply");
#    dpm(serialize($entity), "ente?");
    // reduce to the id because for historical reasons...
    if(is_object($entity))
      $entity_id = $entity->id();
    else
      $entity_id = $entity;

#    dpm($pattern,__FUNCTION__);
    if(isset($pattern['max_id']))
      unset($pattern['max_id']);

#    dpm($entity_id, "eid?");
    // just in case...
    if (empty($pattern)) return $this->createFallbackTitle($entity_id);;

    $parts = array();
    $pattern_order = array_keys($pattern);
    //just to avoid infinite loops we introduce an upper bound,
    //this is possible since per run at most k-1 other elements have to be cycled through before
    //having seen all parents i.e. $max = sum_{k = 0}^$count k
    $count = count($pattern);
    $max = ($count * ($count+1)) / 2;
    $count = 0;

    while ($count < $max && current($pattern) ) { //&& list($key,$attributes) = each($pattern)) {

      $key = key($pattern);
      $attributes = current($pattern);
      $part = array();

      $count++;
      unset($pattern[$key]);
      reset($pattern);
      //dpm($pattern,'Hold '.$key);
      //if we have a dependency make sure we only consider this one, when all dependencies are clear
      if (!empty($attributes['parents'])) {
        foreach ($attributes['parents'] as $parent => $positive) {
#          dpm($parts,'Ask for '.$parent.' '.($positive ? 'pos' : 'neg'));
          if (!isset($parts[$parent])) {
            $pattern[$key] = $attributes;
            continue 2;
          } elseif ($positive) {
 #           // by MyF: added check on empty array since the language sensitive rework requires an array check
            if ($parts[$parent] === '' || empty($parts[$parent])) continue 2;
          } else { //if negative
            if (!empty($parts[$parent])) continue 2;
          }
        }
      }
 #     dpm($parts,'partagain??'.$parent.' '.($positive ? 'pos' : 'neg'));
      if ($attributes['type'] === 'path') {
        $name = $attributes['name'];

        //$part = array();
        $values = array();
//        unset($values);
        switch ($name) {
          case 'eid':
            $values = array($entity_id);
            break;
          case 'uri.long':
          case 'uri.short':
            $values = array($this->getUriString($entity_id,$name));
            break;
          case 'bundle_label':
            $values = array($this->label());
            break;
          case 'bundle_id':
            $values = array($this->id());
            break;
          default: {
            list($pb_id,$path_id) = explode('.',$attributes['name']);
            $values = $this->gatherTitleValues($entity, $path_id, $pb_id);
#            dpm($values,'gathered values for '.$path_id);
          }
        }
        if (empty($values)) {
          if ($attributes['optional'] === FALSE) {
            //we detected an invalid title;
            \Drupal::messenger()->addError('Detected invalid title');
#            dpm("oh real weh");
            return $this->createFallbackTitle($entity_id);
          } else $parts[$key] = '';
          continue;
        }

        $cardinality = $attributes['cardinality'];
        // here we did not check for languaged tags
        // @TODO: Make this check for sanity!
        // MyFi: fixed this :)

        #$available_languages = \Drupal::languageManager()->getLanguages();
        #$available_languages = array_keys($available_languages);

//        if ($cardinality < 0 || $cardinality > count($values)) $cardinality = count($values);
#        dpm(count($values[$available_languages[0]]), "count is!");
        $delimiter = $attributes['delimiter'];
#        dpm($delimiter, "delimiter is?");
        // MyFi: reset i per $language, so we put it into the foreach afterwards
        // $i = 0;
#        dpm($values, "values");

        foreach ($values as $language => $per_lang_values) {
          // we have to evaluate cardinality here because it is per language...
          if (is_array($per_lang_values))
            if ($cardinality < 0 || $cardinality > count($per_lang_values)) $cardinality = count($per_lang_values);
          else
            if ($cardinality < 0 || $cardinality > count($values)) $cardinality = count($values);

          $i = 0;
          if (is_int($language) || !is_array($per_lang_values)) {
            $value = $per_lang_values;
            //
            // fix for empty values, we ignore these for now.
            // a numeric 0 oder the string "0" also is empty, but we want to
            // print them as is
            if(empty($value) && $value !== 0 && $value !== "0")
              continue;
#          dpm($i, "i");
#          dpm($cardinality, "card");
#	TODO: We have to reimplement this. I've thrown this out due to language thingies
            // MyFi: commented this in again because this is important for the functionality of "Show#" in the title pattern setting of the bundle
            // otherwise multiple values would be written one following another without the delimiter if the setting is: "Show#1"
            if ($i >= $cardinality) break;
#          dpm($value, 'get');
            foreach($available_languages as $alanguage) {
              if(empty($part[$alanguage]))
                $part[$alanguage] = "";
              $part[$alanguage] .= "$value";

              // we found something for this language!
              $has_any_path_part_per_language[$alanguage] = TRUE;
            }
            if (++$i < $cardinality) $part[$alanguage] .= $delimiter;
          } else {
            // this takes still place if the something just uses a group title
            // e.g. the fotoliste in horizonte just uses the object title for its
            // entries and then suddenly there was "en" => "blablabla" instead of
            // an array.
            if(!is_array($per_lang_values)) {
              $value = $per_lang_values;
              if(empty($value) && $value !== 0 && $value !== "0")
                continue;

              if ($i >= $cardinality) break;
#          dpm($value, 'get');
#              dpm($language, "language");
              if(empty($part[$language]))
                $part[$language] = "";
              # before: if multiple entries were in $value, then they were concatenated to $part[$language]
              # before:  $part[$language] .= "$value";
              # this is wrong since this did not consider delimiters that were given in the title pattern
              # we need an iteration here over all entries in $value so we deleted we "}" after this block to
              # include this in the outer foreach loop
              $part[$language] .= "$value";
              // we found something for this language!
              $has_any_path_part_per_language[$language] = TRUE;
              // }
              if (++$i < $cardinality) $part[$language] .= $delimiter;
            } else {

              // iterate language ...
              foreach($per_lang_values as $per_lang_value) {
                $value = $per_lang_value['value'];
                if(empty($value) && $value !== 0 && $value !== "0")
                  continue;
#          dpm($i, "i");
#	TODO: SEE ABOVE
#          dpm($cardinality, "card");
              // MyFi: commented this in again because this is important for the functionality of "Show#" in the title pattern setting of the bundle
              // otherwise multiple values would be written one following another without the delimiter if the setting is: "Show#1"
                if ($i >= $cardinality) break;
#          dpm($value, 'get');
#              dpm($language, "language");
                if(empty($part[$language]))
                  $part[$language] = "";
              # before: if multiple entries were in $value, then they were concatenated to $part[$language]
              # before:  $part[$language] .= "$value";
              # this is wrong since this did not consider delimiters that were given in the title pattern
              # we need an iteration here over all entries in $value so we deleted we "}" after this block to
              # include this in the outer foreach loop
                $part[$language] .= "$value";
              // we found something for this language!
                $has_any_path_part_per_language[$language] = TRUE;
              // }
                if (++$i < $cardinality) $part[$language] .= $delimiter;
              }
            }
          }
        }
#        dpm($part[$language]);
      }

      if ($attributes['type'] === 'text') {
#        dpm(serialize($attributes));
#        dpm($available_languages, "avail?");
        foreach($available_languages as $language) {
          // MyFi: we add additional text blocks defined in the title pattern only for languages, where entries exist.
          // If an entry is not translated, we do not want any text block to be added
          // Later in the code (I think in another .php file), we following can be observed:
          // If a title in the displayed language does not exist (= if no translation exists), the title in the
          // original language will be taken instead
          // we described our decision to use the title in the original language if no translation exists in our
          // DHD paper that will hopefully published October 2021
          //
          // By Mark:
          // This does not work - $part[$language] is always empty. It is not built together like that as every
          // part for element is pushed to the parts array. You at least would have to check the parts array for entries
          // but this is too complicated either. Lets better sort it out later on...
//          if(isset($part[$language])){
            $part[$language] = $attributes['label'];
//          }
        }
#        dpm($part, "part?");
      }
      //if (!empty($attributes['children'])){dpm($part,'Part');dpm($parts,'Parts '.$key);}

      $parts[$key] = $part;
    }

#    dpm(array('parts'=>$parts),'after');
#    return "yay?";
    //reorder the parts according original pattern
    $title = array();
    foreach($available_languages as $alanguage) {
      $title[$alanguage][0]["value"] = "";
      $title[$alanguage][0]["wisski_language"] = $alanguage;
      foreach ($pattern_order as $pos) {
        if (isset($parts[$pos]) && isset($parts[$pos][$alanguage])){
          $title[$alanguage][0]["value"] .= $parts[$pos][$alanguage];
        }
      }
      // if the title is an empty string we probably unset it, because
      // there seems to be no translation!
      // this is an assumption and might prove wrong.
      if (empty(trim($title[$alanguage][0]["value"]))) unset($title[$alanguage]);


      // here we should kill titles consisting only of static elements, too, because that
      // usually is an error in multi-lingual-settings.
      if(!isset($has_any_path_part_per_language[$alanguage])) unset($title[$alanguage]);

 #     dpm($title);
#      if (empty(trim($title[$alanguage]))) $title[$alanguage] = $this->createFallbackTitle($entity_id);
    }

    if(empty($title)) {
      return $this->createFallbackTitle($entity_id);
    }


#    dpm($title, "tit?");
#    return "yay?";
    #dpm(func_get_args()+array('result'=>$title),__METHOD__);
    return $title;
  }

  public function createFallbackTitle($entity_id) {

    // we have to add the languages, otherwise it will become ugly.
    // here we have to iterate the languages
    $available_languages = \Drupal::languageManager()->getLanguages();
    $available_languages = array_keys($available_languages);

    $title = array();

    foreach($available_languages as $lang) {
      $title[$lang][0] = array("value" => $this->fallback_title . " " . $entity_id);
    }


    switch ($this->onEmpty()) {
      case self::FALLBACK_TITLE: return $title; # TODO: The below case has to be rewritten...
      case self::DEFAULT_PATTERN: return $title;#return $this->applyTitlePattern($this->getDefaultPattern(),$entity_id);
      case self::DONT_SHOW:
      default: return FALSE;
    }
  }

  public function gatherTitleValues($eid, $path_id, $pb_id = NULL) {
    $values = array();
    $moduleHandler = \Drupal::service('module_handler');
    if (!$moduleHandler->moduleExists('wisski_pathbuilder')){
      return NULL;
    }

    $language = \Drupal::service('language_manager')->getCurrentLanguage()->getId();

    // This is the case for create-dialog-thingies where the id is
    //still empty.
    if(is_object($eid) ) {
      if(empty($eid->id())) {

        // Early opt out if it is not a new entity but we don't have
        // the entity id - which probably is bad!
        if(!$eid->isNew()) {
          return;
        }

        // Try to build it with the values at hand...
        if(!empty($pb_id)) {
          if(isset($this->pb_cache[$pb_id]))
            $pb = $this->pb_cache[$pb_id];
          else {
            $this->pb_cache = WisskiPathbuilderEntity::loadMultiple();
            $pb = $this->pb_cache[$pb_id];
          }

          $path = $pb->getPbPath($path_id);

          if(isset($path['field'])) {

            if(!$eid->hasField($path['field'])) {
              return;
            }

            // Get all the values from the current entity.
            $values = $eid->get($path['field'])->getValue();

            if(empty($values)) {
              return;
            }

            $out_values = array();

            // Go in there and gather these.
            foreach($values as $value) {
              // What is the main prop?
              // Hopefully we don't need that.
              if(isset($value['value'])) {
                $fieldValue = $value['value'];

                // Check if this is a list field and if so, get the label instead of the key.
                if(isset($path['fieldtype']) && in_array($path['fieldtype'], ['list_string', 'list_integer', 'list_float'])) {
                  $fieldStorageDefinition = $eid->getFieldDefinition($path['field'])->getFieldStorageDefinition();
                  $allowedValues = \Drupal::moduleHandler()->moduleExists('options') ? options_allowed_values($fieldStorageDefinition, $eid) : array();

                  // Remove any html tags from the allowed values.
                  // This comes from the possibility to wrap labels in html tags.
                  foreach ($allowedValues as $key => $value) {
                    $allowedValues[$key] = strip_tags($value);
                  }

                  // Use the label if available, otherwise fall back to the raw value.
                  if(isset($allowedValues[$fieldValue])) {
                    $fieldValue = $allowedValues[$fieldValue];
                  }
                }

                $out_values[] = $fieldValue;
              } else {
                // ??
              }

            }

            // Return what we've got.
            return $out_values;
          }
        } else {
          \Drupal::messenger()->addError("This should not happen! WissKI Bundle Title Generation error");
        }
      } else {
        $eid = $eid->id();
      }
    }

    if(empty($this->pb_cache)) {
      $this->pb_cache = WisskiPathbuilderEntity::loadMultiple();
    }

    $pbs = $this->pb_cache;

    if(empty($this->adapter_cache)) {
      $this->adapter_cache = Adapter::loadMultiple();
    }

    $field_is_translatable = TRUE;

    $adapters = $this->adapter_cache;
    // We ask all pathbuilders if they know the path.
    foreach ($pbs as $pb_id => $pb) {
      if ($pb->hasPbPath($path_id)) {
        // If the PB knows the path we try to load it.
        $path = WisskiPathEntity::load($path_id);

        if (empty($path)) {
          continue;
        }


        // Then we try to load the path's adapter.
        $adapter = $adapters[$pb->getAdapterId()];
        if (empty($adapter)) {
          continue;
        }

        // Only do this if there is data!
        if (AdapterHelper::getUrisForDrupalId($eid, $adapter->id(), FALSE)) {
          // Finally, having a valid path and adapter, we can ask the adapter for the path's value.
          $pbpath = $pb->getPbPath($path_id);

          // Fetch field and bundle.
          $pbfield = $pbpath['field'];
          $pbbundle = $pbpath['bundle'];

          // Load field def so we can see if the translation is enabled or not.
          // If it is not, we don't return everything here.
          $field_defs = \Drupal::service('entity_field.manager')->getFieldDefinitions("wisski_individual", $pbbundle);


          if(isset($field_defs) && isset($field_defs[$pbfield])) {
            $fielddef = $field_defs[$pbfield];

            // If it is not translatable take only the first one.
            // This might backfire in case there are several fields
            // and only one is not translatable...
            // But don't worry about that for now.
            if(!$fielddef->isTranslatable()) {
              $field_is_translatable = FALSE;
            }

          }


          // This is the case when the thing is a group.
          // In this case we want it to generate the title of the
          // subentity and use that.
          if($pbpath['bundle'] == $pbpath['field'] || $pbpath['fieldtype'] == "entity_reference") {

            // Get the data from the pathbuilder.

            // In case of entity_reference which is not a group, be absolute!
            if($pbpath['fieldtype'] == "entity_reference" && $pbpath['bundle'] != $pbpath['field']) {
              // In case of entity reference this may not be
              // absolute... I don't know why it was.
              // Use case: Edit form with some sub-value field
              // and there is an entity reference in it.
              // Then we may not do this here. Example is divination
              // historische einordnung
              $tmp = $adapter->getEngine()->pathToReturnValue($path, $pb, $eid, 0, "target_id", TRUE);
            } else {
              $tmp = $adapter->getEngine()->pathToReturnValue($path, $pb, $eid, 0, "target_id", TRUE);
            }

            // Absolute?
            $grptitles = array();

            // Iterate through the data we've got.
            foreach($tmp as $key => $item) {

              // Construct the drupal id.
              $item_eid = $adapter->getEngine()->getDrupalId($item["target_id"]);

              // Get the bundle of the data.
              $bundleid = $pb->getBundleIdForEntityId($item_eid);
              if(empty($bundleid))
                continue;

              $bundle = \Drupal\wisski_core\Entity\WisskiBundle::load($bundleid);

              if(empty($bundle))
                continue;

              // Generate the title of that.
              $mytitle = $bundle->generateEntityTitle($item_eid);
               if (isset($mytitle[$language])){
                 $grptitles[] = $mytitle[$language][0]["value"];
               }
               else {
                 $mytitle = current($mytitle);
                 $grptitles[] = $mytitle[0]["value"];
               }
            }

            // By Mark: This is wrong in tafelmalerei context.
            // It does not resolve recursive titles anymore.
            $new_values[] = array( "value" => implode(", ", $grptitles), "wisski_language" => $language);

          } else { // Normal field handling.
            $bundle_of_path = $pbpath['bundle'];

            // If this is empty, then we get the parent and take this.
            if((empty($bundle_of_path) || $path->getType() == "Path") && !empty($pbpath['parent'])) {
              $group = $pb->getPbPath($pbpath['parent']);
              $bundle_of_path = $group['bundle'];
            }

            // Get the group-object for the current bundle we're on.
            $groups = $pb->getGroupsForBundle($this->id());

            // If there are several groups, for now take only the first one.
            $group = current($groups);

            if(empty($group)) {
              // There should not be any error message here, this is a normal case
              continue;
            }
            // If the bundle and this object are not the same, the eid is the one of the
            // main bundle and the paths have to be absolute. In this case
            // we have to call it with false.
            if($bundle_of_path != $this->id()) {
              // If this bundle is not the bundle where the path is in, we go to
              // absolute mode and give the length of the group because we find
              // $eid there.
              $new_values = $adapter->getEngine()->pathToReturnValue($path, $pb, $eid, count($group->getPathArray())-1, "value", FALSE);
            } else // if not they are relative.
              $new_values = $adapter->getEngine()->pathToReturnValue($path, $pb, $eid, 0, "value", TRUE);
            if (WISSKI_DEVEL) \Drupal::logger($pb_id.' '.$path_id.' '.__FUNCTION__)->debug('Entity @eid output', ['@eid' => $eid, 'out' => serialize($new_values)]);
          }

          // If it is not translatable take only the first one.

        }
        if (empty($new_values)) {
        } else {
          // Add the values to the array.
          foreach($new_values as $new_value) {
            // Check if this is a list field and if so, get the label instead of the key.
            if(isset($new_value['value']) && isset($pbpath['fieldtype']) && in_array($pbpath['fieldtype'], ['list_string', 'list_integer', 'list_float'])) {
              $fieldStorageDefinition = isset($fielddef) ? $fielddef->getFieldStorageDefinition() : null;

              if($fieldStorageDefinition && \Drupal::moduleHandler()->moduleExists('options')) {
                $allowedValues = options_allowed_values($fieldStorageDefinition);

                // Remove any html tags from the allowed values.
                // This comes from the possibility to wrap labels in html tags.
                foreach ($allowedValues as $key => $value) {
                  $allowedValues[$key] = strip_tags($value);
                }

                // Use the label if available, otherwise fall back to the raw value.
                if(isset($allowedValues[$new_value['value']])) {
                  $new_value['value'] = $allowedValues[$new_value['value']];
                }

              }
            }

            if(isset($new_value["wisski_language"]))
              $values[$new_value["wisski_language"]][] = $new_value;
            else
              $values[] = $new_value;
          }

          // If the field is not translatable take the first one.
          if(!$field_is_translatable) {

            $values = array($language => current($values));
          }
        }
      }
    }

    return $values;
  }

  public static function defaultPathOptions() {

    return array(
      'eid' => t('Entity\'s Drupal ID'),
      'uri.long' => t('Full URI'),
      'uri.short' => t('Short URI'),
      'bundle_label' => t('The bundle\'s label'),
      'bid' => t('The bundle\'s ID'),
    );
  }

  public function getPathOptions() {

    $options = &$this->path_options;
    //if we already gathered the data, we can stop here
    if (empty($options)) {
      $options = self::defaultPathOptions();

      $moduleHandler = \Drupal::service('module_handler');
      if (!$moduleHandler->moduleExists('wisski_pathbuilder')){
        return NULL;
      }


      //find all paths from all active pathbuilders
      $pbs = \Drupal::service('entity_type.manager')->getStorage('wisski_pathbuilder')->loadMultiple();
#      $paths = array();
      foreach ($pbs as $pb_id => $pb) {
        #$paths = $pb->getAllPathsForBundleId($this->id(), TRUE);
        $paths = $pb->getAllPathsAndGroupsForBundleId($this->id(), TRUE);

#        dpm($paths);

        while($path = array_shift($paths)) {

          // see what is in the pathbuilder exactly
          $pbp = $pb->getPbPath($path->id());

          // if it is empty or it is disabled, continue
          if(empty($pbp) || !$pbp['enabled'])
            continue;

#          dpm($paths);
          if($path->isGroup()) {
            $options[$pb_id][$pb_id.'.'.$path->id()] = $path->getName() . ' (group label)';

            // in case of groups, get the subpaths and add them to the path... we continue there
            // directly to have the paths in the correct order
            $paths = array_merge($pb->getAllPathsAndGroupsForBundleId($pbp['bundle'], TRUE), $paths);
#            dpm($pb->getPbPath($path->id()), "yay!");
            #dpm($pb->getAllPathsAndGroupsForBundleId($path->id(), TRUE));

          }
          else
            $options[$pb_id][$pb_id.'.'.$path->id()] = $path->getName();
        }
/*
        $pb_paths = $pb->getAllPaths();
        foreach ($pb_paths as $path) {
          $path_id = $path->getID();
          if ($this->id() === $pb->getBundle($path_id)) {
            $options[$pb_id][$pb_id.'.'.$path_id] = $path->getName();
          }
        }
*/
      }
    }
    return $options;
  }

  public function getUriString($entity_id,$type) {

    $uris = AdapterHelper::getUrisForDrupalId($entity_id);
    if (empty($uris)) return '';
    $uri = current($uris);
    if ($type === 'uri.long') return $uri;
    if ($type === 'uri.short') {
      $matches = array();
      if (preg_match('/^.*[\#\/](.+)$/',$uri,$matches)) {
        return $matches[1];
      } else {
        \Drupal::messenger()->addError("no match for URI $uri");
      }
    }
    return '';
  }

  /**
   * Flushes the cache of generated entity titles
   * @param $entity_ids an array of IDs of entities whose titles shall be removed from this bundle's cache list, if NULL, all titles will be deleted
   */
  public function flushTitleCache($entity_ids = NULL) {

    if (is_null($entity_ids)) {
      unset($this->cached_titles);
      WisskiCacheHelper::flushAllEntityTitles($this->id());
    } elseif (!empty($entity_ids)) {
      foreach ((array) $entity_ids as $entity_id) {
        unset($this->cached_titles[$entity_id]);
        WisskiCacheHelper::flushEntityTitle($entity_id,$this->id());
      }
    }
  }

  private function setCachedTitle($entity_id,$title) {
#    dpm("I am called");
    $this->cached_titles[$entity_id] = $title;

    // if so it is probably a language-array with titles.
    if(is_array($title)) {
      foreach($title as $language => $title) {
        #dpm($title);
        #dpm($language);
        WisskiCacheHelper::putEntityTitle($entity_id,$title[0]["value"],$this->id(), $language);
      }
    } else {
      // for now we do nothing, but it might be useful to do something
      // probably dpm here and see if we ever run into this.
    }
  }

  public function getCachedTitle($entity_id) {
#    dpm(microtime(), "got cached title!");
    if (!isset($this->cached_titles[$entity_id])) {
#      dpm("fetch fresh");
// we have to iterate this due to language thingies.
//      if ($title = WisskiCacheHelper::getEntityTitle($entity_id,$this->id())) $this->cached_titles[$entity_id] = $title;
      $available_languages = \Drupal::languageManager()->getLanguages();
      $available_languages = array_keys($available_languages);

      $title = array();

      foreach($available_languages as $lang) {
        $titleperlang = WisskiCacheHelper::getEntityTitle($entity_id,$this->id(),$lang);
        if(!empty($titleperlang))
          $title[$lang][0] = array("value" => $titleperlang, "wisski_language" => $lang);
        $this->cached_titles[$entity_id] = $title;
      }

      if(empty($title))
        return NULL;
      //else return NULL;
    }//dpm($this->cached_titles,'cached titles');
#    dpm(microtime(), "delivered.");
    return $this->cached_titles[$entity_id];
  }

  public function setTitlePattern($title_pattern) {
    $input = serialize($title_pattern);
    if ($input !== $this->title_pattern) {
      $this->title_pattern = $input;
      $this->flushTitleCache();
    }

#    $config = \Drupal::configFactory()->getEditable('wisski_core.wisski_bundle_title');
#    $config->set($this->id, $title_pattern)->save();
    $state = \Drupal::state()->get('wisski_core_title_patterns') ?: serialize(array());
    $state = unserialize($state);
    $state[$this->id] = $title_pattern;
    $state = serialize($state);
    \Drupal::state()->set('wisski_core_title_patterns', $state);
  }

  public function onEmpty() {

    return $this->on_empty;
  }

  public function setOnEmpty($type) {

    $type = intval($type);
    if ($type == self::DEFAULT_PATTERN || $type == self::FALLBACK_TITLE || $type == self::DONT_SHOW) {
      $this->on_empty = $type;
    } else \Drupal::messenger()->addStatus('Invalid fallback type for title pattern');
  }

  public function getFallbackTitle() {

    return $this->fallback_title;
  }

  public function setFallbackTitle($fallback_title) {

    if (is_string($fallback_title) && !empty($fallback_title))
      $this->fallback_title = $fallback_title;
  }

  public function getPagerLimit() {
    return $this->pager_limit;
  }

  public function setPagerLimit($limit) {
    $this->pager_limit = $limit;
  }

  public function getParentBundleIds($get_labels=TRUE) {

    $moduleHandler = \Drupal::service('module_handler');
    if (!$moduleHandler->moduleExists('wisski_pathbuilder')){
      return NULL;
    }


    $pbs = \Drupal::service('entity_type.manager')->getStorage('wisski_pathbuilder')->loadMultiple();
    $parents = array();
    foreach ($pbs as $pb_id => $pb) {
      $parent_id = $pb->getParentBundleId($this->id());
      if ($parent_id) {
        if ($get_labels) {
          $parent = self::load($parent_id);
          if (!empty($parent)) {
            $parents[$parent_id] = $parent->label();
          }
        } else $parents[$parent_id] = $parent_id;
      }
    }
    return $parents;
  }

  public function deleteBundleFromMenu($menu_name,  $destination_route = "entity.wisski_bundle.entity_list", $parameters = array() ) {

    if(empty($parameters))
      $parameters = array("wisski_bundle" => $this->id());

    $link = Link::createFromRoute($this->label(), $destination_route, $parameters);

    // generate the parameter-string for the menu_link_content table
    $params = "";
    foreach($parameters as $key => $parameter) {
      $params .= $key . '=' . $parameter. ';';
    }

    // kill the last ; in the end
    $params = substr($params, 0, -1);

#    dpm('route:' . $destination_route . ';' . $params);

    // get the matching entities
    $entities = \Drupal::entityTypeManager()->getStorage('menu_link_content')->loadByProperties(['menu_name' => $menu_name, 'title' => $this->label(), 'link__uri' => 'route:' . $destination_route . ';' . $params ]);

    // typically there should be only one.
    $entity = current($entities);

    if(!empty($entity))
      $entity->delete();

    return $entity;

  }

  /**
   * Creates a view for navigation
   *
   */
  public function addViewForBundle($menu_name, $weight, $enabled) {
    $bundleid = $this->id();
    $bundle_name = $this->label();
    $bundle_uuid = $this->uuid();

    $options = array();
    $options['base_table'] = "wisski_individual";
    $options['id'] = $bundleid;
    $options['label'] = $bundle_name;
    $options['uuid'] = $bundle_uuid;
    $options['module'] = "views";
    $options['core'] = "8.x";
    $options['base_field'] = "eid";
    $options['originalId'] = $bundleid;

    $options['display']['default'] = array(
      'display_plugin' => 'default',
      'id' => 'default',
      'display_title' => 'Master',
      'position' => 0,
      'display_options' => array(
        'access' => array('type' => 'perm', 'options' => array( 'perm' => 'view any wisski content') ),
        'cache' => array('type' => 'none'), #array('type' => 'tag', 'options' => array() ),
        'query' => array('type' => 'views_query', 'options' => array() ),
        'exposed_form' => array('type' => 'basic', 'options' => array(
          'submit_button' => 'Apply',
          'reset_button' => false,
          'reset_button_label' => 'Reset',
          'exposed_sorts_label' => 'Sort by',
          'expose_sort_order' => true,
          'sort_asc_label' => 'Asc',
          'sort_desc_label' => 'Desc',
          ),
        ),
       'pager' => array('type' => 'full', 'options' => array(
         'items_per_page' => 24,
         'offset' => 0,
         'id' => 0,
         'total_pages' => NULL,
         'tags' => array('previous' => '<<', 'next' => '>>', 'first' => '<< First', 'last' => 'Last >>'),
         'expose' => array(
           'items_per_page' => false,
           'items_per_page_label' => 'Items per page',
           'items_per_page_options' => '5, 10, 25, 50',
           'items_per_page_options_all' => false,
           'items_per_page_options_all_label' => '- All -',
           'offset' => false,
           'offset_label' => 'Offset',
         ),
         'quantity' => 9,
         ),
       ),
       'style' => array(
         'type' => 'grid',
         'options' => array(
           'grouping' => array(),
           'columns' => 6,
           'automatic_width' => true,
           'alignment' => 'horizontal',
           'col_class_default' => true,
           'col_class_custom' => '',
           'row_class_default' => true,
           'row_class_custom' => '',
         ),
       ),
       'row' => array(
         'type' => 'fields',
       ),
       'fields' => array(
         'eid' => array(
           'id' => 'eid',
           'table' => 'wisski_individual',
           'field' => 'eid',
           'relationship' => 'none',
           'group_type' => 'group',
           'admin_label' => '',
           'label' => '',
           'exclude' => true,
           'alter' =>
          array(
             'alter_text' => false,
             'text' => '',
             'make_link' => false,
             'path' => '',
             'absolute' => false,
             'external' => false,
             'replace_spaces' => false,
             'path_case' => 'none',
             'trim_whitespace' => false,
             'alt' => '',
             'rel' => '',
             'link_class' => '',
             'prefix' => '',
             'suffix' => '',
             'target' => '',
             'nl2br' => false,
             'max_length' => 0,
             'word_boundary' => true,
             'ellipsis' => true,
             'more_link' => false,
             'more_link_text' => '',
             'more_link_path' => '',
             'strip_tags' => false,
             'trim' => false,
             'preserve_tags' => '',
             'html' => false,
          ),
           'element_type' => '',
           'element_class' => '',
           'element_label_type' => '',
           'element_label_class' => '',
           'element_label_colon' => false,
           'element_wrapper_type' => '',
           'element_wrapper_class' => '',
           'element_default_classes' => true,
           'empty' => '',
           'hide_empty' => false,
           'empty_zero' => false,
           'hide_alter_empty' => true,
           'entity_type' => 'wisski_individual',
           'plugin_id' => 'standard',
        ),
         'preview_image' =>
        array(
           'id' => 'preview_image',
           'table' => 'wisski_individual',
           'field' => 'preview_image',
           'relationship' => 'none',
           'group_type' => 'group',
           'admin_label' => '',
           'label' => '',
           'exclude' => false,
           'alter' =>
          array(
             'alter_text' => false,
             'text' => '',
             'make_link' => false,
             'path' => '',
             'absolute' => false,
             'external' => false,
             'replace_spaces' => false,
             'path_case' => 'none',
             'trim_whitespace' => false,
             'alt' => '',
             'rel' => '',
             'link_class' => '',
             'prefix' => '',
             'suffix' => '',
             'target' => '',
             'nl2br' => false,
             'max_length' => 0,
             'word_boundary' => true,
             'ellipsis' => true,
             'more_link' => false,
             'more_link_text' => '',
             'more_link_path' => '',
             'strip_tags' => false,
             'trim' => false,
             'preserve_tags' => '',
             'html' => false,
          ),
           'element_type' => '',
           'element_class' => '',
           'element_label_type' => '',
           'element_label_class' => '',
           'element_label_colon' => false,
           'element_wrapper_type' => '',
           'element_wrapper_class' => '',
           'element_default_classes' => true,
           'empty' => '',
           'hide_empty' => false,
           'empty_zero' => false,
           'hide_alter_empty' => true,
           'click_sort_column' => 'target_id',
           'type' => 'image_url',
           'settings' =>
          array(
             'image_style' => 'medium',
          ),
           'group_column' => '',
           'group_columns' =>
          array(
          ),
           'group_rows' => true,
           'delta_limit' => 0,
           'delta_offset' => 0,
           'delta_reversed' => false,
           'delta_first_last' => false,
           'multi_type' => 'separator',
           'separator' => ', ',
           'field_api_classes' => false,
           'entity_type' => 'wisski_individual',
           'plugin_id' => 'field',
        ),
         'title' =>
        array(
           'id' => 'title',
           'table' => 'wisski_individual',
           'field' => 'title',
           'relationship' => 'none',
           'group_type' => 'group',
           'admin_label' => '',
           'label' => '',
           'exclude' => false,
           'alter' =>
          array(
             'alter_text' => false,
             'text' => '',
             'make_link' => true,
//             'path' => '/wisski/navigate/{{eid}}/view?wisski_bundle=' . $bundleid,
             'absolute' => false,
             'external' => false,
             'replace_spaces' => false,
             'path_case' => 'none',
             'trim_whitespace' => false,
             'alt' => '',
             'rel' => '',
             'link_class' => '',
             'prefix' => '',
             'suffix' => '',
             'target' => '',
             'nl2br' => false,
             'max_length' => 0,
             'word_boundary' => true,
             'ellipsis' => true,
             'more_link' => false,
             'more_link_text' => '',
             'more_link_path' => '',
             'strip_tags' => false,
             'trim' => false,
             'preserve_tags' => '',
             'html' => false,
          ),
           'element_type' => '',
           'element_class' => '',
           'element_label_type' => '',
           'element_label_class' => '',
           'element_label_colon' => false,
           'element_wrapper_type' => '',
           'element_wrapper_class' => '',
           'element_default_classes' => true,
           'empty' => '',
           'hide_empty' => false,
           'empty_zero' => false,
           'hide_alter_empty' => true,
           'entity_type' => 'wisski_individual',
           'plugin_id' => 'standard',
        ),
      ),
       'filters' =>
      array(
         'bundle' =>
        array(
           'id' => 'bundle',
           'table' => 'wisski_individual',
           'field' => 'bundle',
           'relationship' => 'none',
           'group_type' => 'group',
           'admin_label' => '',
           'operator' => 'IN',
           'value' =>
          array(
             $bundleid => $bundleid,
          ),
           'group' => 1,
           'exposed' => false,
           'expose' =>
          array(
             'operator_id' => '',
             'label' => '',
             'description' => '',
             'use_operator' => false,
             'operator' => '',
             'identifier' => '',
             'required' => false,
             'remember' => false,
             'multiple' => false,
             'remember_roles' =>
            array(
               'authenticated' => 'authenticated',
            ),
             'reduce' => false,
          ),
           'is_grouped' => false,
           'group_info' =>
          array(
             'label' => '',
             'description' => '',
             'identifier' => '',
             'optional' => true,
             'widget' => 'select',
             'multiple' => false,
             'remember' => false,
             'default_group' => 'All',
             'default_group_multiple' =>
            array(
            ),
             'group_items' =>
            array(
            ),
          ),
           'entity_type' => 'wisski_individual',
           'plugin_id' => 'wisski_bundle',
        ),
      ),
       'sorts' => array(),
       'title' => $bundle_name,
       'header' => array(
         'result' => array(
           'id' => 'result',
           'table' => 'views',
           'field' => 'result',
           'relationship' => 'none',
           'group_type' => 'group',
           'admin_label' => '',
           'empty' => false,
           'content' => 'Displaying @start - @end of @total',
           'plugin_id' => 'result',
         ),
       ),
       'footer' => array(),
       'empty' => array(),
       'relationships' => array(),
       'arguments' => array(),
       'display_extenders' => array(),
       'use_ajax' => FALSE,
    ),
     'cache_metadata' =>
    array(
       'max-age' => -1,
       'contexts' =>
      array (
        0 => 'languages:language_interface',
        1 => 'url.query_args',
      ),
       'tags' =>
      array(
      ),
    ),
   );

    $options['display'][$bundleid] = array(
      'display_plugin' => 'page',
      'id' => $bundleid,
      'display_title' => $bundle_name,
      'position' => 1,
      'display_options' => array(
        'display_extenders' => array(),
        'path' => 'wisski_views/' . $bundleid,
        'menu' => array(
          'type' => 'normal',
          'title' => $bundle_name,
          'description' => '',
          'expanded' => FALSE,
          'parent' => '',
          'weight' => $weight,
          'context' => '0',
          'menu_name' => $menu_name,
        ),
      ),
      'cache_metadata' => array(
        'max-age' => -1,
        'contexts' => array (
          0 => 'languages:language_interface',
          1 => 'url.query_args',
        ),
        'tags' => array(),
      ),
    );

    $view = new View($options, 'view');

    $view->enable();
    $view->save();

  }

  public function addMenuItem($menu_name, $weight, $enabled, $destination_route, $parameters) {
    $link = Link::createFromRoute($this->label(), $destination_route, $parameters);

    $entity = MenuLinkContent::create(array(
      'link' => ['uri' => $link->getUrl()->toUriString()],
       #        'langcode' => $node->language()->getId(),
      ));

    $entity->enabled->value = $enabled;


#    dpm($entity, "bundle");
#    $entity->id = $name;
    $entity->title->value = trim($this->label());
#    $entity->description->value = trim($group->getDe);
    $entity->menu_name->value = $menu_name;
#    $entity->parent->value = $values['parent'];
    $entity->weight->value = isset($entity->weight->value) ? $entity->weight->value : $weight;
    $entity->save();
  }

  /**
   * Adds a menu entry for a bundle
   * e.g. to navigate, find or create
   */
  public function addBundleToMenu($menu_name, $destination_route = "entity.wisski_bundle.entity_list", $parameters = array() ) {
#    drupal_set_message("I should add " . $this->id() . " to $menu_name");
    $menu_mode = $this->getCreateMenuItems($menu_name, self::MENU_CREATE);

    $weight = 0;
    $enabled = TRUE;
    $found_menu_item = FALSE;
    $found_view = FALSE;

    $set = \Drupal::configFactory()->getEditable('wisski_core.settings');
    $use_views = $set->get('wisski_use_views_for_navigate');

    // we can only use views for navigate
    if($use_views && $menu_name != 'navigate') {
      $use_views = FALSE;
    }

    if (!$menu_mode) {
      // the setting says that we should not create a menu item
      return;
    }


    // first: get the old weight
    if(empty($parameters))
      $parameters = array("wisski_bundle" => $this->id());

    // generate the parameter-string for the menu_link_content table
    $params = "";
    foreach($parameters as $key => $parameter) {
      $params .= $key . '=' . $parameter. ';';
    }

    // kill the last ; in the end
    $params = substr($params, 0, -1);

    // get the matching entities
    $entities = \Drupal::entityTypeManager()->getStorage('menu_link_content')->loadByProperties(['menu_name' => $menu_name, 'title' => $this->label(), 'link__uri' => 'route:' . $destination_route . ';' . $params ]);

    if(!empty($entities)) {
      // typically there should be only one.
      $entity = current($entities);

      $found_menu_item = TRUE;

      if(!empty($entity)) {
        if(isset($entity->weight->value))
          $weight = $entity->weight->value;
        if(isset($entity->enabled->value))
          $enabled = $entity->enabled->value;
      }
    }

    $view = NULL;

    // now we should have the values for the menu-part... lets see if there is a view?
    // only do this for navigate
    if($menu_name == "navigate") {
      $view = \Drupal::service('entity_type.manager')->getStorage('view')->load($this->id());

      if(!empty($view)) {
        $display = $view->getDisplay($this->id());
        if(isset($display['display_options']['menu']['weight']))
          $weight = $display['display_options']['menu']['weight'];
        if(isset($display['display_options']['menu']['enabled']))
          $enabled =  $display['display_options']['menu']['enabled'];
        $found_view = TRUE;
      }
    }

    // if we didn't find a view or a menu we can assume pb-input as truth
    if(!$found_view && !$found_menu_item) {

#      $weight = 0;

      $moduleHandler = \Drupal::service('module_handler');
      if (!$moduleHandler->moduleExists('wisski_pathbuilder')){
        return NULL;
      }


      // only act if there is no entity. Otherwise we can just check if everything is ok.
      $pbs = WisskiPathbuilderEntity::loadMultiple();

      $groups = array();
      //we ask all pathbuilders if they know the bundle
      foreach ($pbs as $pb_id => $pb) {
        $groups = array_merge($groups, $pb->getGroupsForBundle($this->id()));

        if(!empty($groups)) // we take the first one for now
          $group = current($groups);

        if(!empty($group)) {
          $pbp = $pb->getPbPath($group->id());
          $weight = $pbp['weight'];
          break;
        }
      }
    }

#    drupal_set_message("I should add " . $this->id() . " to $menu_name and v:$found_view and m:$found_menu_item and uv:$use_views with weight:$weight and enabled " . serialize($enabled));

    // if there is a view and we are in menu create mode, we delete the view and create the menu.
    if($found_view && !$use_views && !empty($view)) {
      $view->delete();
      #$this->addViewForBundle($menu_name, $weight, $enabled);
    }

    // if there is a menu but we want to use views
    if($found_menu_item && $use_views) {
      $this->deleteBundleFromMenu($menu_name,  $destination_route, $parameters);
    }

    // if we want to use views and we didn't find any - create it
    if(!$found_view && $use_views) {
      $this->addViewForBundle($menu_name, $weight, $enabled);
    }

    // we didn't find a menu item and we don't want to use views
    if(!$found_menu_item && !$use_views) {
      $this->addMenuItem($menu_name, $weight, $enabled, $destination_route, $parameters);
    }


      // for further usage: language coding... currently no support at this point
/*
    if ($entity->isTranslatable()) {
      if (!$entity->hasTranslation($node->language()->getId())) {
        $entity = $entity->addTranslation($node->language()->getId(), $entity->toArray());
      }
      else {
        $entity = $entity->getTranslation($node->language()->getId());
      }
    }
    */

  }


  /** For each of the menus associated with this bundle, returns information
   * whether to create a menu item for this bundle and whether it should be
   * enabled by default.
   *
   * @param menu_name restrict the return value to the info for this menu
   * @param filter filter the menus' info. Can be MENU_CREATE, MENU_ENABLE or a
            combination thereof
   * @return an array where the keys are menu ids and the values are
   *         MENU_CREATE, MENU_ENABLE or a combination thereof. If menu_name is
   *         given, only the menu's info is returned; if the menu does not
   *         exist or was filtered out, FALSE is returned.
   */
  public function getCreateMenuItems($menu_name = NULL, $filter = NULL) {
    $menus = $this->menu_items + self::getCreateMenuItemDefaults();
    if ($filter !== NULL) {
      $menus = array_filter($menus, function($v) use ($filter) {
        return $v & $filter;
      });
    }
    if ($menu_name !== NULL) {
      if (isset($menus[$menu_name])) {
        return $menus[$menu_name];
      }
      // either the menu name does not exist or it was filtered out
      return FALSE;
    }
    return $menus;
  }


  public function setCreateMenuItems($items) {
    $this->menu_items = $items;
  }

  public static function getCreateMenuItemDefaults() {
    // currently we always want to create items for every menu
    return array_fill_keys(array_keys(self::getWissKIMenus()), self::MENU_CREATE | self::MENU_ENABLE);
  }


}
