<?php

namespace Drupal\wisski_editlayout\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for WissKI Edit Layout settings.
 */
class LayoutSwitcherForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['wisski_editlayout.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'wisski_editlayout_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('wisski_editlayout.settings');

    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable WissKI Edit Layout'),
      '#default_value' => $config->get('enabled') ?? TRUE,
      '#description' => $this->t('Enable or disable the custom edit layout for WissKI forms.'),
    ];

    $form['layout_style'] = [
      '#type' => 'select',
      '#title' => $this->t('Layout Style'),
      '#default_value' => $config->get('layout_style') ?? 'std',
      '#options' => [
        'std' => $this->t('Standard Layout'),
        'compact' => $this->t('Compact Layout'),
        'minimal' => $this->t('Minimal Layout'),
      ],
      '#description' => $this->t('Select the layout style to apply to WissKI individual forms.'),
      '#states' => [
        'visible' => [
          ':input[name="enabled"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['apply_to_all_forms'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Apply to all WissKI forms'),
      '#default_value' => $config->get('apply_to_all_forms') ?? FALSE,
      '#description' => $this->t('Apply the layout to all WissKI forms, not just individual forms.'),
      '#states' => [
        'visible' => [
          ':input[name="enabled"]' => ['checked' => TRUE],
        ],
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('wisski_editlayout.settings')
      ->set('enabled', $form_state->getValue('enabled'))
      ->set('layout_style', $form_state->getValue('layout_style'))
      ->set('apply_to_all_forms', $form_state->getValue('apply_to_all_forms'))
      ->save();

    // Clear cache to ensure form alterations take effect.
    \Drupal::service('cache.render')->invalidateAll();
  }

}
