# WissKI 3D Data Model

A Drupal recipe that extends the [WissKI Default Data Model](https://www.drupal.org/project/wisski_default_data_model) with 3D model viewing capabilities for cultural heritage digitization projects.

## Overview

The WissKI 3D Data Model recipe builds upon the comprehensive WissKI Default Data Model by adding specialized functionality for viewing and managing 3D models of cultural heritage objects. This recipe is ideal for museums, archives, and research institutions that are digitizing artifacts using 3D scanning technologies and need to integrate these models into their semantic data infrastructure.

Built on WissKI (**Wissenschaftliche Kommunikationsinfrastruktur** - Scientific Communication Infrastructure), this recipe combines semantic web technology with modern 3D visualization capabilities, allowing cultural heritage professionals to document both the metadata and the three-dimensional representation of objects in a unified system.

## Key Features

- **3D Model Viewing**: Interactive 3D model display using the Model Viewer component
- **Inherits Full Data Model**: All features from WissKI Default Data Model including CIDOC-CRM compliance, geospatial data, authority documents, and multi-language support
- **Multiple 3D Format Support**: Compatible with glTF, GLB, and other web-optimized 3D formats
- **Semantic Integration**: 3D models are fully integrated with the CIDOC-CRM ontology for cultural heritage documentation
- **FAIR Principles**: Maintains Findable, Accessible, Interoperable, and Reusable data practices for 3D content

## Prerequisites

Before installing this recipe, ensure you have:

1. **SPARQL 1.1 Endpoint**: A functional SPARQL 1.1 endpoint (recommended: [OpenGDB](https://github.com/FAU-CDI/open_gdb))

2. **WissKI Starter Recipe**: Install the [WissKI Starter](https://www.drupal.org/project/wisski_starter) recipe, load the default data model ontology, and configure a WissKI SALZ adapter with machine name "default"

3. **WissKI Default Data Model Recipe**: This recipe extends the [WissKI Default Data Model](https://www.drupal.org/project/wisski_default_data_model), which must be installed first

4. **WissKI Default Ontology**: Version 2.0.0 or higher of the [WissKI Default Ontology](https://wiss-ki.eu) loaded into your triple store

5. **Composer Configuration**: Prepare Composer to handle recipes:

```bash
composer config allow-plugins.drupal/core-recipe-unpack true
composer require drupal/core-recipe-unpack
```

6. **Conditional Fields Module Workaround**: Due to an unresolved issue with the Conditional Fields module, set minimum stability to 'dev' and add the issue fork:

```bash
composer config minimum-stability dev
composer config repositories.1 git https://git.drupalcode.org/issue/conditional_fields-3495402.git
```

7. **System Requirements**:
   - Drupal 11.x or higher
   - PHP 8.3 or higher (minimum 512MB memory)
   - Apache 2.x with mod_rewrite enabled
   - MySQL 5.7.8+ or MariaDB 10.3.7+
   - Modern web browser with WebGL support for 3D viewing

## Installation

1. **Require the Recipe**: Use Composer to add the WissKI 3D Data Model recipe:

```bash
composer require 'drupal/wisski_3d_data_model:^1.0'
```

2. **Apply the Recipe**: Use Drush to apply the recipe:

```bash
drush recipe ../recipes/wisski_3d_data_model
```

3. **Recreate WissKI Menus**: Rebuild the WissKI menus to incorporate new functionalities:

```bash
drush wisski-core:recreate-menus
```

4. **Clear Caches**: Ensure all caches are cleared to reflect the changes:

```bash
drush cr
```

### Docker Installation

For quick evaluation and testing, consider using the [WissKI Docker setup](https://wiss-ki.eu/documentation/wisski-docker) which can be configured to include this recipe.

## Included Modules

This recipe extends the WissKI Default Data Model with:

### 3D Visualization
- **model_viewer_formatter**: Provides the Model Viewer web component for rendering 3D models in supported formats (glTF, GLB)

### Inherited Modules

All modules from the WissKI Default Data Model are included:
- **WissKI Core Modules**: wisski_starter, wisski_authority_document, wisski_editlayout, wisski_permalink
- **Media & Display**: colorbox, ds, field_group, viewfield
- **Forms**: conditional_fields
- **Geospatial**: geofield, leaflet
- **Localization**: language, locale, content_translation, config_translation

See the [WissKI Default Data Model documentation](https://www.drupal.org/project/wisski_default_data_model) for complete details on inherited functionality.

## Working with 3D Models

### Supported Formats

The Model Viewer component supports:
- **glTF** (.gltf): GL Transmission Format with external assets
- **GLB** (.glb): Binary glTF with embedded assets (recommended)
- **USDZ**: Universal Scene Description (for AR on iOS devices)

### Best Practices

1. **Optimize Models**: Use web-optimized formats with appropriate polygon counts for browser viewing
2. **File Size**: Keep GLB files under 50MB for optimal loading performance
3. **Textures**: Use compressed texture formats when possible
4. **Metadata**: Document 3D models with capture method, resolution, and processing information

### Integration with Cultural Heritage Items

3D models are treated as media files within the WissKI data model and can be:
- Associated with Cultural Heritage Item entities
- Linked to specific documentation records
- Connected to provenance and digitization activities
- Enriched with rights and licensing information

## Usage

### Getting Started

1. **Install Dependencies**: Ensure WissKI Default Data Model is installed and configured
2. **Configure SPARQL Endpoint**: Verify your triple store connection
3. **Upload 3D Models**: Add 3D model files as media items to your cultural heritage objects
4. **Configure Display**: Set up the Model Viewer formatter for 3D model fields
5. **View Content**: Browse your cultural heritage items with interactive 3D models

### Adding 3D Models to Items

When editing a Cultural Heritage Item:
1. Navigate to the Media section
2. Add a new media file of type "3D Model"
3. Upload your GLB or glTF file
4. Add metadata including capture date, method, and rights information
5. Save and view the interactive 3D model on the item page

## Configuration Details

### Import Settings

All module configurations are imported with flexible settings (`strict: false`) to allow for customization while maintaining compatibility with the base data model.

### Customization

This recipe provides the foundation for 3D viewing. You may want to customize:
- Display formatters for different view modes
- Field configurations for 3D model metadata
- Permissions for 3D model upload and viewing
- Model Viewer appearance and interaction settings

## Support and Documentation

- **WissKI Project**: [https://www.drupal.org/project/wisski](https://www.drupal.org/project/wisski)
- **WissKI Documentation**: [https://wiss-ki.eu/documentation](https://wiss-ki.eu/documentation)
- **Model Viewer**: [https://modelviewer.dev/](https://modelviewer.dev/)
- **CIDOC-CRM**: [https://www.cidoc-crm.org/](https://www.cidoc-crm.org/)

## License

This project is licensed under the GNU General Public License v2.0 or later. See LICENSE.md for details.

## Contributing

Contributions are welcome! Please follow the standard Drupal contribution guidelines and submit patches via the project's issue queue.

---

*This recipe extends the WissKI Default Data Model with 3D visualization capabilities for cultural heritage digitization projects. For specific implementation questions or advanced customization needs, consult the WissKI documentation or engage with the community.*
