# WissKI Default Data Model

A comprehensive Drupal recipe that installs a [WissKI Environment](https://www.drupal.org/project/wisski) with a preconfigured pathbuilder and data model specifically designed for recording and managing cultural heritage items.

## Overview

The WissKI Default Data Model provides a ready-to-use semantic data framework for cultural heritage institutions, museums, archives, and research projects. Built on WissKI (**Wissenschaftliche Kommunikationsinfrastruktur** - Scientific Communication Infrastructure), this recipe includes preconfigured WissKI entities, bundles, forms, views, and all necessary modules to immediately start cataloging and managing cultural heritage objects with rich metadata and semantic relationships.

WissKI is a free and open virtual research environment for managing scholarly data that extends Drupal's content management framework while providing the benefits of semantic web technology through simple and intuitive input interfaces.

## Key Features

- **Comprehensive Cultural Heritage Data Model**: Predefined structure for cultural heritage items including dimensions, materials, techniques, provenance, and media files
- **FAIR Principles Compliance**: Implements Findable, Accessible, Interoperable, and Reusable data principles
- **Semantic Web Compliance**: Built on CIDOC-CRM ontology (specifically ECRM implementation) for standardized cultural heritage documentation
- **Rich Media Support**: Integrated support for images, audio, video, and documents with metadata and rights management
- **Geospatial Data**: Built-in support for location data with mapping capabilities via Leaflet
- **Authority Documents**: Integration with external authority files and controlled vocabularies
- **Multi-language Support**: Content translation capabilities for international projects
- **Customizable Forms**: Flexible form layouts with conditional fields and field grouping
- **Advanced Views**: Pre-configured display modes and views for browsing and searching collections

## Prerequisites

Before installing this recipe, ensure you have:

1. **SPARQL 1.1 Endpoint**: A working SPARQL endpoint (recommended: [OpenGDB](https://github.com/FAU-CDI/open_gdb))
2. **WissKI Starter Recipe**: Must be installed first as a dependency
3. **Default Data Model Ontology**: Load the appropriate CIDOC-CRM ontology into your triple store
4. **WissKI SALZ Adapter**: Configure an adapter with machine name "default"
5. **System Requirements**:
   - Drupal 11.x or higher
   - PHP 8.3 or higher (minimum 512MB memory)
   - Apache 2.x with mod_rewrite enabled
   - MySQL 5.7.8+ or MariaDB 10.3.7+

## Installation

### Via Composer

```bash
composer require drupal/wisski_default_data_model
```

### Recipe Installation

```bash
# Install the recipe using Drupal's recipe system
php core/scripts/drupal recipe recipes/wisski_default_data_model
```

### Docker Installation

For quick evaluation and testing, consider using the [WissKI Docker setup](https://wiss-ki.eu/documentation/wisski-docker) which includes a complete environment with sample data.

## Included Modules

This recipe automatically installs and configures the following modules:

### Core WissKI Modules
- **wisski_starter**: Base WissKI functionality
- **wisski_authority_document**: Authority file integration
- **wisski_editlayout**: Enhanced editing layouts
- **wisski_permalink**: Persistent identifier support

### Drupal Contrib Modules
- **colorbox**: Lightbox functionality for media
- **conditional_fields**: Dynamic form behavior
- **config_translation**: Configuration translation support
- **content_translation**: Content translation capabilities
- **ds**: Display Suite for flexible layouts
- **field_group**: Logical grouping of form fields
- **geofield**: Geographic data support
- **leaflet**: Interactive mapping
- **viewfield**: Embedded views in entities

### Localization
- **language**: Multi-language infrastructure
- **locale**: Interface translation

## Data Model Structure

The default data model is built around the concept of **Cultural Heritage Items** and follows the CIDOC-CRM international standard for cultural heritage documentation. The pathbuilder provides a graphical interface to create ontology-driven structures and serves as middleware between Drupal's frontend and SPARQL endpoints.

### Main Entity Types

### Core Entities

#### Cultural Heritage Item
- **Title References**: Multiple title assignments with visibility controls
- **Object Type**: Classification and categorization
- **Identifiers**: Various identification numbers and codes
- **Descriptions**: Detailed object descriptions
- **Physical Properties**: Dimensions, materials, techniques
- **Keywords**: Subject terms and tags
- **Provenance**: Item history and activities
- **Media**: Associated images, documents, audio, and video
- **Data Records**: Metadata about the documentation itself
- **Resources**: Related external resources

#### Supporting Entities

##### Dimensions
- Type (height, width, depth, etc.)
- Value (numerical measurement)
- Unit (cm, mm, inches, etc.)

##### Item History Activities
- Activity type (creation, acquisition, restoration, etc.)
- Actors involved (artists, collectors, institutions)
- Dates and time periods
- Places and locations

##### Media Files
- Type classification (image, audio, video, document)
- File storage and URLs
- Rights and licensing information
- Descriptions and metadata

##### Data Records
- Record identifiers
- Rights management
- Language specifications
- Record types
- Digitization processes
- Associated actors

##### Geographic Information
- Places with spatial coordinates
- Authority names and custom names
- Alternative place names
- Geographic relationships

##### Temporal Information
- Periods with begin/end dates
- Precision indicators
- Textual date descriptions
- Structured date fields (year, month, day)

## Configuration Details

### Layout Style
The recipe configures WissKI Edit Layout with a minimal style for clean, user-friendly forms.

### Import Settings
All module configurations are imported with flexible settings (strict: false) to allow for customization while maintaining the core data model structure.

## Usage

### Getting Started

1. **Configure SPARQL Endpoint**: Ensure your triple store is accessible and the "default" adapter is configured
2. **Load Ontology**: Import the default data model ontology into your triple store
3. **Create Content**: Start creating cultural heritage items using the preconfigured forms
4. **Customize Views**: Modify the included views to match your presentation needs
5. **Configure Maps**: Set up Leaflet mapping for geographic data visualization

### Form Modes

The recipe includes specialized form modes:
- **Default**: Standard editing interface
- **Reference Text**: Simplified reference editing
- **Reference Detailed**: Comprehensive reference form

### Content Management

- Use the preconfigured bundles for different types of cultural heritage objects
- Leverage conditional fields for context-sensitive form elements
- Utilize field groups for organized data entry
- Take advantage of authority document integration for standardized vocabularies

## Customization

### Extending the Data Model
- Add custom fields to existing bundles
- Create new entity types for specialized content
- Modify pathbuilder configurations for additional semantic relationships
- Implement custom views for specific browsing needs

### Theming
- Customize Display Suite layouts
- Modify Colorbox settings for media display
- Adjust Leaflet map configurations
- Style conditional field behaviors

## Support and Documentation

- **Detailed Data Model Information**: [WissKI Barrels - Default Model](https://wisski-barrels.de/barrels/default)
- **WissKI Project**: [Drupal.org Project Page](https://www.drupal.org/project/wisski)
- **Official Documentation**: [wiss-ki.eu Documentation](https://wiss-ki.eu/documentation)
- **Community Support**: [WissKI Chat](https://chat.wiss-ki.eu) or email support
- **Issue Tracking**: Report issues via the [Drupal.org issue queue](https://www.drupal.org/project/issues/wisski_default_data_model?categories=All)

## License

GPL-2.0-or-later

## Maintainer

**Robert Nasarek** - Primary maintainer and developer

## Development Partners

WissKI was initially developed by:
- Digital Humanities Research Group, Friedrich-Alexander-University Erlangen-Nuremberg (FAU)
- Department of Museum Informatics, Germanisches Nationalmuseum (GNM) Nuremberg
- Biodiversity Informatics Group, Zoologisches Forschungsmuseum Alexander Koenig (ZFMK) Bonn

Software development was funded by the German Research Foundation (Deutsche Forschungsgemeinschaft, DFG) from 2009-2012 and 2014-2017.

## Contributing

Contributions are welcome! Please follow the standard Drupal contribution guidelines and submit patches via the project's issue queue.

---

*This recipe provides a solid foundation for cultural heritage data management. For specific implementation questions or advanced customization needs, consult the WissKI documentation or engage with the community.*
