# WissKI Starter

This recipe provides the foundational WissKI environment for collection objects data literacy projects. It serves as the base layer that prepares a WissKI instance with essential configurations and modules.

## Overview

The `WissKI Starter` recipe establishes the core WissKI environment with essential WissKI modules and dependencies.
Visit [WissKI Default ](https://www.drupal.org/project/wisski_base) recipe


## Installed modules

- [IMCE](https://www.drupal.org/project/imce) (for file uploading)
- [WissKI](https://www.drupal.org/project/wisski)
  - WissKI Autocomplete (autocomplete widget)
  - WissKI Core (core entity and functions)
  - WissKI Pathbuilder (semantic modeling)
  - WissKI SPARQL1.1 Adapter with Pathbuilder (triplestore connector)
  - WissKI Store Abstraction Layer Zero (abstract adapter interface)
- [Inline Entity Form](https://www.drupal.org/project/inline_entity_form) (for nested entity generation)

## Usage
Install the recipe with composer:
```bash
composer require drupal/wisski_starter
```
Add installer type to composer.json:
```yml
"installer-types": [
    ...
    "drupal-recipe"
],
```
Install the recipe with:
```bash
drush recipe ../recipes/wisski_starter -v
```

[Learn more about recipes here](https://www.drupal.org/docs/extending-drupal/drupal-recipes).
