<?php

namespace Drupal\wordsonline_connector\Entity;

/**
 * WordsOnline Request Json Response.
 */
class WolRequestJsonResponse
{

  /**
   * Status
   *
   * @var string
   */
  public $status = "";

  /**
   * Message.
   *
   * @var string
   */
  public $message = "";

  /**
   * @var object
   */
  public $data = NULL;

  /**
   * Constructor.
   */
  public function __construct()
  {

  }

  /**
   * Init without define data.
   *
   * @param string $status
   *   Status.
   * @param string $content
   *   Message.
   */
  public static function createWithoutData($status, $message)
  {
    $instance = new self();
    $instance->status = $status;
    $instance->message = $message;
    return $instance;
  }

  /**
   * Init .
   *
   * @param string $status
   *   Status.
   * @param string $content
   *   Message.
   * @param object $data
   * Data
   */
  public static function createFull($status, $message, $data)
  {
    $instance = new self();
    $instance->status = $status;
    $instance->message = $message;
    $instance->data = $data;
    return $instance;
  }

}
