<?php

namespace Drupal\wordsonline_connector\Common;
use Drupal\tmgmt\Entity\Job;
use Drupal\tmgmt\Entity\JobItem;
use Drupal\tmgmt\JobInterface;
use Drupal;
use Drupal\wordsonline_connector\WordsOnlineConst;

class WordsOnlineHelper {
    /**
     * Get service level name
     *
     * @param string $conntent_type
     * Content type.
     */
    public static function getServiceLevelName(string $conntent_type) {
        $name ="service_level";
        if(strlen($conntent_type) > 0){
            $conntent_type = str_replace(' ','_',$conntent_type);
            $conntent_type = str_replace('-','_',$conntent_type);
            $conntent_type = str_replace('/','_',$conntent_type);
            $conntent_type = str_replace('\\','_',$conntent_type);
            $conntent_type = str_replace('?','_',$conntent_type);
            $conntent_type = str_replace('.','_',$conntent_type);
            $conntent_type = str_replace('[','_',$conntent_type);
            $conntent_type = str_replace(']','_',$conntent_type);
            $conntent_type = str_replace('(','_',$conntent_type);
            $conntent_type = str_replace(')','_',$conntent_type);
            $conntent_type = str_replace('!','_',$conntent_type);
            $conntent_type = str_replace('@','_',$conntent_type);
            $conntent_type = str_replace('<','_',$conntent_type);
            $conntent_type = str_replace('>','_',$conntent_type);
            $name .= $conntent_type;
        }

        return $name;
    }

    /**
     * Get Service Level
     *
     * @param Drupal\tmgmt\JobInterface $job
     * Job.
     */
    public static function getServiceLevel(Job|JobInterface $job) {
      $service_level = $job->getSetting('service_level');
      if(!isset($service_level) || $service_level == NULL) {
        $content_type = $job->getSetting('content_type');
        if($content_type != NULL) {
           $service_level_name = WordsOnlineHelper::getServiceLevelName($content_type);
           $service_level = $job->getSetting($service_level_name);
        }
      }
      return $service_level;
    }

    /**
     * Clear the token cache.
     */
    public static function clearTokenCache()
    {
      $cache = Drupal::cache(WordsOnlineConst::MODULE_ID);
      if(isset($cache)) {
       $cache->delete('token');
      }
    }
}
