const { createApp, ref, reactive, watch, nextTick } = Vue;

const app = createApp({
  setup() {
    const errorMessage = ref("");
    const successMessage = ref("");
    const totalRecords = ref(0);
    const select_job = ref();
    const quote_detail = reactive({
      dtp_page_count: 0,
      word_count: 0,
      display_Tm_savings: false,
      amount_without_TM: 0,
      content_type: "",
      service_level: "",
      estimate_date: null,
      source_language: "",
      target_language: "",
      request_name: "",
      items_to_translate: 0,
      request_id: "",
      tm_leverage: 0,
      tm_leverage_percentage: 0,
      quote_items: [],
      quote_sections: [],
      addition_preferences: [],
    });
    const list_options = ref([
      {
        icon: "wol-list-type-active-icon",
        value: false,
        title: "List Order"
      },
      {
        icon: "wol-list-type-icon",
        value: true,
        title: "Failed List"
      }
    ]);
    const is_failled = ref(list_options.value[0]);
    const rowOptions = [10, 20, 30, 50];
    const limit = ref(rowOptions[0]);
    const offset = ref(0);
    const show_dialog = ref(false);
    const show_view_quote_dialog = ref(false);
    const show_download_dialog = ref(false);
    const loading = ref(false);
    const type_options = ref([{ code: -1, label: "All Types" }, { code: 0, label: "Normal" }, { code: 1, label: "Continuous" }]);
    const selected_type = ref(type_options.value[0]);
    const job_list = ref([]);
    const job_item_list = ref([]);
    const keyword = ref("");
    const file_name = ref("");
    const tabs = ref([]);
    const origin_uri = ref(window.location.origin);
    function parseToUTC(str) {
      const [datePart, timePart] = str.split(' ');
      const [year, month, day] = datePart.split('-').map(Number);
      const [hours, minutes, seconds] = timePart ? timePart.split(':').map(Number) : [0, 0, 0];
      const utcDate = new Date(Date.UTC(year, month - 1, day, hours, minutes, seconds));
      return utcDate;
    }
    watch(() => quote_detail.estimate_date, function (new_due_date, old_due_date) {
      if ([0, 6].includes(new_due_date instanceof Date ? new_due_date.getDay() : parseToUTC(new_due_date).getUTCDay())) {
        alert("You can't choose weekend as due date");
        nextTick(() => {
          quote_detail.estimate_date = old_due_date;
        });
      }
    });
    function showJobItem(job) {
      select_job.value = job;
      loading.value = true;
      let url = getRootUrl() + "get-request-detail?request_guid=" + job.request_guid;
      axios.get(url)
        .then(function (response) {
          job_item_list.value = response.data.data;
          loading.value = false;
          show_dialog.value = true;
        })
        .catch(function (error) {
          console.log(error);
          loading.value = false;
        })
    }
    function hideDiaglog() {
      show_dialog.value = false;
    }
    function changeJobType(e) {
      const val = e.value;
      selected_type.value = val;
      getJobList();
    }
    function changeOption(e) {
      limit.value = e.value;
      getJobList();
    }
    function search() {
      keyword.value = document.getElementById("wol_searchbox").value;
      offset.value = 0;
      getJobList();
    }
    function getRootUrl() {
      return window.location.origin + window.location.pathname.replace('wordsonline/jobs', 'wordsonline/').replace('wordsonline/wol-order', 'wordsonline/').replace('wordsonline/requests', 'wordsonline/')
    }
    function getJobList() {
      loading.value = true;
      let type = selected_type.value.code;
      let per_page = limit.value;
      let skip = offset.value;//page.value;
      let show_retry = is_failled.value.value;
      let url = getRootUrl() + "get-job-list?type=" + type + "&per_page=" + per_page + "&skip=" + skip + "&show_retry=" + show_retry;
      if (keyword.value && keyword.value != '' && keyword.value != null) {
        url += "&q=" + keyword.value;
      }
      axios.get(url)
        .then(function (response) {
          job_list.value = response.data.data;
          totalRecords.value = response.data.count;
          loading.value = false;
        })
        .catch(function (error) {
          console.log(error);
          loading.value = false;
        })
    }
    function importTranslation(job) {
      loading.value = true;
      let url = getRootUrl() + "import-job?request_guid=" + job.request_guid + "&job_id=" + job.job_id;
      axios.post(url)
        .then(function (response) {
          if (response.status == 200 && response.data.status == "success") {
            //do nothing

          } else {
            showError("Can't import data for job " + job.job_id);
          }
          loading.value = false;
          getJobList();
        })
        .catch(function (error) {
          console.log(error);
          showError("Can't import data for job " + job.job_id);
          loading.value = false;
        })
    }
    function downloadFile(job) {
      loading.value = true;
      let url = getRootUrl() + "download-delivery-file?request_guid=" + job.request_guid;
      axios({
        url: url,
        method: 'GET',
        responseType: 'blob',
      }).then((response) => {
        // create file link in browser's memory
        const href = URL.createObjectURL(response.data);
        // create "a" HTML element with href to file & click
        const link = document.createElement('a');
        link.href = href;
        link.setAttribute('download', file_name.value);
        document.body.appendChild(link);
        link.click();

        // clean up "a" element & remove ObjectURL
        document.body.removeChild(link);
        URL.revokeObjectURL(href);
        loading.value = false;
      }).catch(function (error) {
        console.log(error);
        loading.value = false;
      });
    }
    function viewFile(job) {
      select_job.value = job;
      loading.value = true;
      let url = getRootUrl() + "show-delivery-file?request_guid=" + job.request_guid;
      axios.get(url)
        .then(function (response) {

          if (response.status == 200) {
            let delivery_datas = response.data.data;
            file_name.value = response.data.file_name;
            let tab_datas = [];
            for (let i = 0; i < delivery_datas.length; i++) {
              tab_datas.push(
                {
                  title: delivery_datas[i].fileName,
                  content: delivery_datas[i].content,
                  value: i
                }
              );
            }
            tabs.value = tab_datas;
            show_download_dialog.value = true;
          } else {
            showError("Can't get delivery file for job " + job.job_id);
          }
          loading.value = false;

        })
        .catch(function (error) {
          console.log(error);
          loading.value = false;
        })
    }
    function showError(msg) {
      errorMessage.value = msg;
      setTimeout(hideError, 3000);
    }
    function hideError() {
      errorMessage.value = "";
    }
    function showSuccess(msg) {
      successMessage.value = msg;
      setTimeout(hideSuccess, 3000);
    }
    function hideSuccess() {
      successMessage.value = "";
    }
    function confirmOrder() {
      loading.value = true;
      let url = getRootUrl() + "confirm-quote?request_guid=" + select_job.value.request_guid;
      if (quote_detail.estimate_date && quote_detail.estimate_date != '') {
        url += "&due_date=" + getDateStringFormat(quote_detail.estimate_date);
      }
      axios.get(url)
        .then(function (response) {
          loading.value = false;
          if (response.status == 200) {
            if (response.data.status == "success") {
              showSuccess(response.data.message);
              getJobList();
            } else {
              showError(response.data.message);
            }

          } else {
            showError("Can't confirm the quote.");
          }

          show_view_quote_dialog.value = false;
        })
        .catch(function (error) {
          console.log(error);
          showError("Can't confirm the quote.");
          loading.value = false;
          show_view_quote_dialog.value = false;
        })

    }
    function getDateStringFormat(val) {
      if (val == "" || val == null) return "";
      try {
        let date = new Date(val);
        let ret = date.getUTCFullYear() + "-";
        let month = date.getUTCMonth() + 1;
        let m = month.toString().padStart(2, '0');
        ret += m + "-";
        let d = date.getUTCDate();
        let dateStr = d.toString().padStart(2, '0');
        ret += dateStr;
        return ret;
      } catch {
        return "";
      }
    }
    function cancelOrder() {
      loading.value = true;
      let url = getRootUrl() + "cancel-quote?request_guid=" + select_job.value.request_guid + "&job_id=" + select_job.value.job_id;
      if (quote_detail.estimate_date && quote_detail.estimate_date != '') {
        url += "&due_date=" + getDateStringFormat(quote_detail.estimate_date);
      }
      axios.get(url)
        .then(function (response) {
          loading.value = false;
          if (response.status == 200) {
            if (response.data.status == "success") {
              showSuccess(response.data.message);
              getJobList();
            } else {
              showError(response.data.message);
            }

          } else {
            showError("Can't cancel the quote.");
          }
          show_view_quote_dialog.value = false;
        })
        .catch(function (error) {
          console.log(error);
          showError("Can't cancel the quote.");
          loading.value = false;
          show_view_quote_dialog.value = false;
        })
    }
    function viewQuote(job) {
      loading.value = true;
      select_job.value = job;
      let url = getRootUrl() + "get-quote-data?request_guid=" + job.request_guid;
      axios.get(url)
        .then(function (response) {
          if (response.status == 200 && response.data.status == "success") {
            let quote = response.data.data;
            let items_to_translate = response.data.items_to_translate;
            let addition_preferences = response.data.addition_preferences;
            quote_detail.dtp_page_count = quote.dtpPageCount;
            quote_detail.word_count = quote.wordCount;
            quote_detail.display_Tm_savings = quote.displayTmSavings;
            quote_detail.amount_without_TM = quote.amountWithoutTM;
            quote_detail.content_type = job.content_type;
            quote_detail.service_level = job.service_level;
            quote_detail.estimate_date = job.due_date;
            quote_detail.source_language = job.source_language_name;
            quote_detail.target_language = job.target_language_name;
            quote_detail.request_name = job.request_name;
            quote_detail.items_to_translate = items_to_translate;
            quote_detail.request_id = quote.request_id;
            quote_detail.tm_leverage = quote.tmLeverage;
            quote_detail.quote_items = quote.quoteItems;
            quote_detail.tm_leverage_percentage = quote.tmLeveragePercentage;
            quote_detail.quote_sections = quote.quoteSections;
            quote_detail.addition_preferences = addition_preferences;
            show_view_quote_dialog.value = true;

          } else {
            showError("Can't get the quote.");
          }
          loading.value = false;
        })
        .catch(function (error) {
          console.log(error);
          showError("Can't get the quote.");
          loading.value = false;
        })
    }
    function getStatusClass(status) {
      return 'wol-status-' + status.toLowerCase().replace(' ', '-');
    }
    function retry(job) {
      loading.value = true;
      let url = getRootUrl() + "retry?id=" + job.id + "&job_id=" + job.job_id;
      axios.get(url)
        .then(function (response) {
          if (response.status == 200 && response.data.status == "success") {
            showSuccess("New order created!");
            loading.value = false;
            getJobList();
          } else {
            showError("Can't re-create the request.");
            loading.value = false;
          }

        })
        .catch(function (error) {
          console.log(error);
          showError("Can't re-create the request.");
          loading.value = false;
        })
    }

    function auto(is_loading) {
      if (is_loading == true) {
        loading.value = true;
      }
      let url = getRootUrl() + "auto-action";
      axios.get(url)
        .then(function (response) {
          if (response.status == 200) {
            if (is_loading == true || response.data.is_change == true) {
              showSuccess("Data has changed. Loading change ...");
              getJobList();
            }
          } else {
            showError("Can't auto processing.");
          }
          if (is_loading == true) {
            loading.value = false;
          }
        })
        .catch(function (error) {
          console.log(error);
          showError("Can't auto processing.");
          if (is_loading == true) {
            loading.value = false;
          }
        })
    }
    function changePage(e) {
      offset.value = e.page;
      getJobList();
    }
    function changeListType(e) {
      is_failled.value = e.value;
      getJobList();
    }
    function importJobItem(job_item_id, request_guid, job_id) {
      loading.value = true;
      let url = getRootUrl() + "import-job-item?request_guid=" + request_guid + "&job_id=" + job_id + "&job_item_id=" + job_item_id;
      axios.get(url)
        .then(function (response) {
          job_item_list.value = response.data.data;
          if (response.status == 200 && response.data.status == "success") {
            loading.value = false;
            showSuccess("Import job item successfully!");
            showJobItem(select_job.value);
          } else {
            loading.value = false;
            showError("Import failled.");

          }
        })
        .catch(function (error) {
          console.log(error);
          loading.value = false;
          showError("Import failled.");
        })
    }
    function getDateFormat(val) {
      if (val == "" || val == null) return "";
      try {
        let date = new Date(val);
        let ret = "";
        let month_arr = ['Jan ', 'Feb ', 'Mar ', "Apr ", "May ", "Jun ", "Jul ", "Aug ", "Sep ", "Oct ", "Nov ", "Dec "];
        ret = month_arr[date.getMonth()];
        let d = date.getDate();
        let dateStr = d > 9 ? d.toString() : "0" + d.toString();
        ret += dateStr + ", " + date.getFullYear();
        return ret;
      } catch {
        return "";
      }
    }
    function addDots(val) {
      let str = val.toString();
      return str.replace(/\d(?=(\d{3})+(?!\d))/g, '$&,');
    }
    getJobList();
    auto(false);
    return {
      selected_type,
      type_options,
      job_list,
      show_dialog,
      select_job,
      loading,
      totalRecords,
      show_view_quote_dialog,
      quote_detail,
      errorMessage,
      limit,
      successMessage,
      offset,
      rowOptions,
      job_item_list,
      origin_uri,
      show_download_dialog,
      tabs,
      file_name,
      keyword,
      list_options,
      is_failled,
      changeListType,
      showJobItem,
      hideDiaglog,
      getRootUrl,
      getJobList,
      changeJobType,
      search,
      importTranslation,
      downloadFile,
      viewQuote,
      retry,
      showError,
      hideError,
      confirmOrder,
      cancelOrder,
      getStatusClass,
      viewFile,
      showSuccess,
      hideSuccess,
      auto,
      changeOption,
      changePage,
      importJobItem,
      getDateFormat,
      getDateStringFormat,
      addDots
    };
  },
  template: `
    <div data-theme="light">
      <div class="wol-row">
       <div class="wol-col-auto">
        <p-button label="Refresh Page" icon="pi pi-refresh" @click="auto(true)">
        <template #icon>
         <svg version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="16px" height="16px" xmlns="http://www.w3.org/2000/svg">
           <g transform="matrix(1 0 0 1 -44 -178 )">
            <path d="M 16 4.284618470336955E-05  C 16 4.284618470336955E-05  13.599991406703936 2.3999871524208847  13.599991406703936 2.3999871524208847  C 12.199998892495165 0.8999951769275849  10.199988199254868 0  7.999999989539505 0  C 3.6000021470164545 0  0 3.6000021308026913  0 8  C 0 12.399997869197309  3.6000021260954673 16  7.999999989539505 16  C 11.700001595879163 16  14.799984981345307 13.39999250557885  15.700001580188422 10.000010716776423  C 15.700001580188422 10.000010716776423  13.600012829796258 10.000010716776423  13.600012829796258 10.000010716776423  C 12.800017113368671 12.299998409743353  10.600007480560986 14.00001070631593  8.000021412631831 14.00001070631593  C 4.700017664505967 14.00001070631593  2.0000321372536094 11.300003752440823  2.0000321372536094 8.000021423092353  C 2.0000321372536094 4.70001767065153  4.700039087598292 2.0000321398687744  8.000021412631831 2.0000321398687744  C 9.7000123048102 2.0000321398687744  11.100026221190305 2.7000283978884463  12.200020336508478 3.8000225146449327  C 12.200020336508478 3.8000225146449327  9.000016068626806 7.0000267867108095  9.000016068626806 7.0000267867108095  L 16 7.0000267867108095  L 16 4.284618470336955E-05  Z " fill-rule="nonzero" fill="#ffffff" stroke="none" transform="matrix(1 0 0 1 44 178 )" />
           </g>
         </svg>
        </template>
        </p-button>
        </div>
        <div class="wol-col"></div>
        <div class="wol-col-auto">
            <p-iconfield>
              <p-inputtext placeholder="Search by request name, request id" style="height:2.5rem;" v-model="keyword" @keydown.enter="search" id="wol_searchbox"/>
              <p-inputicon  @click ="search">
               <svg xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" version="1.1" width="14px" height="14px">
                <g transform="matrix(1 0 0 1 -1246 -179 )">
                 <path d="M 10.152466679515783 11.396199882653196  C 10.152466679515783 11.396199882653196  12.871306032559293 13.99984492512314  12.871306032559293 13.99984492512314  L 13.99396214883669 12.924754528361841  C 13.99396214883669 12.924754528361841  11.280266805198865 10.326017770841053  11.280266805198865 10.326017770841053  C 12.178982227800212 9.235722401157249  12.718360058331715 7.841433999457125  12.718360058331715 6.321842287716487  C 12.718360058331715 2.8303860734667126  9.871254819143033 0  6.359180038239593 0  C 2.84710525733615 0  0 2.830386073466711  0 6.3218422877164855  C 0 9.81329850196626  2.8471052391886804 12.643684575432971  6.359180020092121 12.643684575432971  C 7.780819887219187 12.643684575432971  9.093469948067572 12.17987023413087  10.152466679515783 11.396199882653196  Z M 6.351993276961508 1.4882392211416224  C 9.037275870041585 1.4882392211416224  11.21413753148349 3.6523267554022545  11.21413753148349 6.321842287716484  C 11.21413753148349 8.991357820030716  9.037294434903933 11.155445354291345  6.351993276961508 11.155445354291345  C 3.666692100871613 11.155445354291345  1.4898490224395278 8.991357820030716  1.4898490224395278 6.321842287716484  C 1.4898490224395278 3.6523267554022523  3.666710683881432 1.4882392211416224  6.351993276961508 1.4882392211416224  Z " fill-rule="nonzero" fill="#999999" stroke="none" transform="matrix(1 0 0 1 1246 179 )"/>
                </g>
               </svg>
              </p-inputicon>
            </p-iconfield>
        </div>
        <div class="wol-col-auto">
            <p-select v-model="selected_type" :options="type_options" option-label="label"  placeholder="Select a type" style="height:2.5rem;" class="w-full md:w-56" @change="changeJobType"/>
        </div>
          <div class="wol-col-auto">
            <p-selectbutton v-model="is_failled" :options="list_options" style="height:2.5rem;" optionLabel="value" dataKey="value" @change="changeListType">
               <template #option="slotProps">
                <span :class="slotProps.option.icon" :title="slotProps.option.title"></span>
            </template>
            </p-selectbutton>
        </div>
      </div>
      <div class="wol-row  wol-mg-top-10">
       <p-datatable :value="job_list" style="min-height: 68.5vh;">
        <p-column header="Id">
            <template #body="slotProps">
               <span v-if="slotProps.data.id > 0"> {{slotProps.data.id}}</span>
            </template>
        </p-column>
        <p-column field="label" header="Label"></p-column>
        <p-column field="project_id" header="Project ID"></p-column>
        <p-column field="request_name" header="Name"></p-column>
        <p-column field="order_id" header="Order ID"></p-column>
        <p-column header="Language">
            <template #body="slotProps">
             <span class="wol-language-span">{{slotProps.data.source_language_name+ ' to ' + slotProps.data.target_language_name}}</span>
            </template>
        </p-column>
        <p-column  header="Due Date">
          <template #body="slotProps">
             <span >{{getDateFormat(slotProps.data.due_date)}}</span>
            </template>
        </p-column>
        <p-column  header="Status">
          <template #body="slotProps">
             <span :class="getStatusClass(slotProps.data.status)"> {{slotProps.data.status}}</span>
            </template>
        </p-column>
        <p-column  header="Actions">
            <template #body="slotProps">
                <a class="wol-action-btn" href="#" @click="viewQuote(slotProps.data)" v-if="slotProps.data.is_show_view_quote == 1" ><span class="wol-icon wol-view-quote-icon"  title="View Quote"></span></a>
                <a class="wol-action-btn" href="#" @click="showJobItem(slotProps.data)"  v-if="slotProps.data.is_show_view_job_item == 1"><span class="wol-icon wol-view-job-item-icon"  title="View Job Item"></span></a>
                <a class="wol-action-btn" href="#" @click="retry(slotProps.data)"  v-if="slotProps.data.is_show_retry == 1"><span class="wol-icon wol-retry-icon" title="Retry"></span></a>
                <a class="wol-action-btn" href="#" @click="viewFile(slotProps.data)"  v-if="slotProps.data.is_show_download == 1"><span class="wol-icon wol-download-icon" title="Download"></span></a>
                <a class="wol-action-btn" href="#"  @click="importTranslation(slotProps.data)"  v-if="slotProps.data.is_show_import == 1"><span class="wol-icon wol-import-icon" title="Import"></span></a>
                <a class="wol-action-btn" href="#" @click="importTranslation(slotProps.data)"  v-if="slotProps.data.is_show_reimport == 1"><span class="wol-icon wol-re-import-icon" title="Reimport"></span></a>
                <a class="wol-action-btn" :href="origin_uri+'/admin/tmgmt/jobs/'+slotProps.data.job_id" target="_blank"   v-if="slotProps.data.is_show_view_job == 1"><span class="wol-icon wol-view-job-icon" title="View Job"></span></a>
            </template>
        </p-column>
       </p-datatable>
      </div>
      <div class="wol-row" style="position: sticky; bottom: 0;">
        <p-paginator  :rows="limit" :totalRecords="totalRecords" @page="changePage"  template="PrevPageLink PageLinks NextPageLink CurrentPageReport"
    currentPageReportTemplate="{totalRecords} Items">
         <template #end>
          <p-select v-model="limit" :options="rowOptions"  class="w-full md:w-56" @change="changeOption"/>
          </template>
        </p-paginator>
      </div>
      <p-dialog v-model:visible="show_dialog" modal  >
        <template #header>
            <div class="ch-title"><span>{{select_job.label}}</span></div>
        </template>
        <div>
            <a :href="origin_uri+'/admin/tmgmt/jobs/'+ select_job.job_id" target="_blank" >{{select_job.request_name+ ' ' + select_job.source_language_code+ ' to ' + select_job.target_language_code + ' ' +(select_job.job_type == "0"?"Normal":"Continuous")}}</a>
        </div>
        <div class="wol-row  wol-mg-top-10">
            <p-datatable :value="job_item_list">
                <p-column header="Source">
                    <template #body="slotProps">
                     <a :href="origin_uri+'/node/'+slotProps.data.source_id" target="_blank">  {{slotProps.data.source_label}}</a>
                    </template>
                </p-column>
                <p-column header="Revision">
                    <template #body="slotProps">
                     <a :href="origin_uri+'/node/'+slotProps.data.source_id+'/revisions/'+slotProps.data.revision_id+'/view'" target="_blank"> {{getDateFormat(slotProps.data.revision_label)}}</a>
                    </template>
                </p-column>
                  <p-column header="Status">
                  <template #body="slotProps">
                   <span :class="getStatusClass(slotProps.data.status)"> {{slotProps.data.status}}</span>
                  </template>
                </p-column>
                <p-column header="Actions">
                    <template #body="slotProps">
                   <a class="wol-action-btn" :href="origin_uri+'/admin/tmgmt/items/'+slotProps.data.job_item_id" target="_blank"  v-if="slotProps.data.show_view_job_item == 1"><span class="wol-icon wol-review-icon" title="View"></span></a>&nbsp;
                    <a class="wol-action-btn"href="#"  @click="importJobItem(slotProps.data.job_item_id,select_job.request_guid,select_job.job_id)"   v-if="slotProps.data.show_reimport_job_item == 1"><span class="wol-icon wol-re-import-icon" title="Reimport"></span></a>
                    </template>
                </p-column>
            </p-datatable>
        </div>
        <div class="wol-row  wol-mg-top-10">
            <div class="wol-col"></div>
            <div class="wol-col-auto">
                <p-button label="Close" @click="hideDiaglog()" class="p-close-btn"/>
            </div>
        </div>
      </p-dialog>
      <p-dialog v-model:visible="show_view_quote_dialog" modal>
      <template #header>
        <div class="ch-title"><span>Quote Detail</span></div>
      </template>
      <div class="wol-order-info">
      <div class="wol-order-info-summary">
       <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Request Name</div>
        <div class="wol-col quote-content-info">{{quote_detail.request_name}}</div>
       </div>
       <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Items To Translate</div>
        <div class="wol-col quote-content-info">{{quote_detail.items_to_translate}}</div>
       </div>
       <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Language Paire</div>
        <div class="wol-col quote-content-info"><span class="wol-lang-source">{{quote_detail.source_language}}</span>&nbsp;<span class="wol-angle-right-icon"></span>&nbsp;<span class="wol-btn">{{quote_detail.target_language}}</span></div>
       </div>
       <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Content Type</div>
        <div class="wol-col quote-content-info">{{quote_detail.content_type}}</div>
       </div>
        <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Service Level</div>
        <div class="wol-col quote-content-info">{{quote_detail.service_level}}</div>
       </div>
      </div>
      <div class="wol-order-content">
       <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Estimated Delivery Time</div>
        <div class="wol-col quote-content-info">
         <p-datepicker v-model="quote_detail.estimate_date" dateFormat="yy.mm.dd" showIcon  iconDisplay="input">
          <template #inputicon="slotProps">
           <svg version="1.1" @click="slotProps.clickCallback" xmlns:xlink="http://www.w3.org/1999/xlink" width="12px" height="13px" xmlns="http://www.w3.org/2000/svg">
            <g transform="matrix(1 0 0 1 -784 -496 )">
             <path d="M 0 2.3621584242945795  C 0 2.3621584242945795  0 10.26601147811716  0 10.26601147811716  C 0 10.8071282416224  0.18922880514452345 11.270625797247808  0.5676864154333998 11.656504144993349  C 0.9461440257222762 12.0423824927389  1.4007281668164069 12.235321666611672  1.931438838715792 12.235321666611672  C 1.931438838715792 12.235321666611672  9.68329471842651 12.235321666611672  9.68329471842651 12.235321666611672  C 10.222705565274964 12.235321666611672  10.681639793843715 12.0423824927389  11.060097404132591 11.656504144993349  C 11.438555014421468 11.270625797247808  11.627783819565991 10.8071282416224  11.627783819565991 10.26601147811716  C 11.627783819565991 10.26601147811716  11.627783819565991 3.9455902650435495  11.627783819565991 3.9455902650435495  L 10.466310463851812 5.12983760812471  C 10.466310463851812 5.12983760812471  10.466310463851812 9.866826980449352  10.466310463851812 9.866826980449352  C 10.466310463851812 10.195045345198434  10.353208189512543 10.474474493565895  10.127003640834175 10.705114425551745  C 9.900799092155637 10.935754357537585  9.62674358125679 11.05107432353051  9.304837108137463 11.05107432353051  C 9.304837108137463 11.05107432353051  2.3229467114285285 11.05107432353051  2.3229467114285285 11.05107432353051  C 2.0010402383092014 11.05107432353051  1.726984727410354 10.935754357537585  1.5007801787318158 10.705114425551745  C 1.274575630053448 10.474474493565895  1.161473355714179 10.195045345198434  1.161473355714179 9.866826980449352  C 1.161473355714179 9.866826980449352  1.161473355714179 2.748036772040131  1.161473355714179 2.748036772040131  C 1.161473355714179 2.428689173905883  1.274575630053448 2.1514777171921273  1.5007801787318158 1.9164024018988648  C 1.726984727410354 1.6813270866056018  2.0010402383092014 1.5637894289589704  2.3229467114285285 1.5637894289589704  C 2.3229467114285285 1.5637894289589704  6.968840134285415 1.5637894289589704  6.968840134285415 1.5637894289589704  L 8.143363752423284 0.37954208587781024  C 8.143363752423284 0.37954208587781024  1.931438838715792 0.37954208587781024  1.931438838715792 0.37954208587781024  C 1.4007281668164069 0.37954208587781024  0.9461440257222762 0.5724812597505805  0.5676864154333998 0.9583596074961318  C 0.18922880514452345 1.3442379552416721  0 1.8121708941744918  0 2.3621584242945795  Z M 10.70121518747925 0.1267252373548549  C 10.60551326303846 0.038017571206457566  10.488060901224571 -0.004118570214034986  10.348858102037923 0.00031681309338814253  C 10.209655302851274 0.004752196400811271  10.087852853562765 0.055759104436139205  9.983450754172736 0.1533375371993828  C 9.983450754172736 0.1533375371993828  9.435339732375041 0.7255019838565752  9.435339732375041 0.7255019838565752  L 11.288476996548354 2.6016691228952653  C 11.288476996548354 2.6016691228952653  11.849638280769739 2.0428108261603315  11.849638280769739 2.0428108261603315  C 11.945340205210698 1.9363616267822525  11.995366211168403 1.8121708941744918  11.999716298643023 1.6702386283370494  C 12.004066386117472 1.5283063624996072  11.958390467634388 1.408551013199259  11.862688543193599 1.310972580436026  C 11.862688543193599 1.310972580436026  10.70121518747925 0.1267252373548549  10.70121518747925 0.1267252373548549  Z M 11.001371223225647 2.8944044211849853  L 9.148233959052334 1.0049311322240366  L 5.063501820417002 5.156449907969226  L 6.916639084590315 7.032617047007917  L 11.001371223225647 2.8944044211849853  Z M 6.655633836115328 7.298740045453141  L 4.802496571942015 5.409266756492193  L 4.058631613787952 8.043884441099715  L 6.655633836115328 7.298740045453141  Z " fill-rule="nonzero" fill="#666666" stroke="none" transform="matrix(1 0 0 1 784 496 )" />
            </g>
           </svg>
           </template>
         </p-datepicker>
        </div>
       </div>
        <div class="wol-row ch-summary-row-2">
        <div class="wol-col wol-bold">Additional Preferences</div>
        <div class="wol-col quote-content-info">
        <span class="wol-btn wol-mg-r-5" v-for="preference in quote_detail.addition_preferences">{{preference}}</span>
        </div>
       </div>
        <div class="wol-row ch-summary-row-2">
        <div class="wol-col  wol-bold">DTP Pagecount</div>
        <div class="wol-col quote-content-info">{{quote_detail.dtp_page_count}} pages</div>
       </div>
        <div class="wol-row ch-summary-row-2">
        <div class="wol-col  wol-bold">Word Count</div>
        <div class="wol-col quote-content-info">{{addDots(quote_detail.word_count)}} words</div>
       </div>
        <div class="wol-row ch-price-row">
        <div class="wol-col  wol-bold">Order Total</div>
        <div class="wol-col quote-content-info">
          <span v-for="section in quote_detail.quote_sections" class="wol-quote-order-total">
          <strong> {{ section.amount }}</strong> {{ section.currency }}
         </span>
        </div>
       </div>
      </div>
      </div>
      <div  class="wol-row">
       <div class="wol-col"></div>
       <div class="wol-col-auto"> <p-button label="Confirm" @click="confirmOrder()" v-if="select_job.state!='QuoteApproved'"/></div>
        <div class="wol-col-auto"> <p-button label="Cancel" @click="cancelOrder()"  v-if="select_job.state!='QuoteApproved'"/></div>
         <div class="wol-col-auto"> <p-button label="Close" @click="show_view_quote_dialog= false" class="p-close-btn"/></div>
      </div>
      </p-dialog>
       <p-dialog v-model:visible="show_download_dialog" modal>
        <template #header>
        <div class="ch-title"><span>Download</span></div>
      </template>
      <div  class="wol-row">
       <div class="wol-col-auto">
        <p-button label="Download" @click="downloadFile(select_job)">
        <template #icon>
       <svg xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" version="1.1" width="16px" height="15px">
         <g transform="matrix(1 0 0 1 -277 -375 )">
          <path d="M 0 10.714285714285712  L 8 10.714285714285712  L 16 10.714285714285712  L 16 15  L 0 15  L 0 10.714285714285712  Z M 12.266666666666662 6.428571428571425  L 7.999999999999998 10.714285714285712  L 3.7333333333333334 6.428571428571425  L 6.899999999999998 6.428571428571432  L 6.899999999999998 0  L 9.099999999999996 0  L 9.099999999999996 6.428571428571432  L 12.266666666666662 6.428571428571425  Z M 14.933333333333334 12.85714285714286  L 14.933333333333334 11.785714285714285  L 12.8 11.785714285714285  L 12.8 12.85714285714286  L 14.933333333333334 12.85714285714286  Z " fill-rule="nonzero" fill="#ffffff" stroke="none" transform="matrix(1 0 0 1 277 375 )"/>
         </g>
        </svg>
        </template>
       </p-button>
       </div>
       <div class="wol-col"></div>
      </div>
     <div >
        <details v-for="tab in tabs" class="wol-accordion wol-mg-top-10">
         <summary>
         <div class ="wol-row">
          <div class="wol-col-auto">
          <span class="summary-icon"></span>
          </div>
           <div>
            {{tab.title}}
          </div>
         </div>

          </summary>
         <div class="description">
         <pre>
         {{tab.content}}
         </pre>
         </div>
        </details>
        </div>
         <div  class="wol-row wol-mg-top-10">
          <div class="wol-col"></div>
           <div class="wol-col-auto"> <p-button label="Close" @click="show_download_dialog = false" class="p-close-btn"/></div>
         </div>
       </p-dialog>
      <div class="wol-overlay" v-if="loading">
        <div class="wol-overlay-content">
            <p-progressspinner></p-progressspinner>
        </div>
      </div>
      <div  class="wol-msg error" v-if="errorMessage!=''">
        {{errorMessage}}
      </div >
      <div  class="wol-msg success" v-if="successMessage!=''">
        {{successMessage}}
      </div >
    </div>`
});

app.use(PrimeVue.Config, {
  theme: {
    preset: PrimeUIX.Themes.Aura,
    options: {
      darkModeSelector: '.dark'
    }
  },
});


app.component("p-select", PrimeVue.Select);
app.component("p-button", PrimeVue.Button);
app.component("p-iconfield", PrimeVue.IconField);
app.component("p-inputicon", PrimeVue.InputIcon);
app.component("p-inputtext", PrimeVue.InputText);
app.component("p-datatable", PrimeVue.DataTable);
app.component("p-column", PrimeVue.Column);
app.component("p-dialog", PrimeVue.Dialog);
app.component("p-progressspinner", PrimeVue.ProgressSpinner);
app.component("p-paginator", PrimeVue.Paginator);
app.component("p-datepicker", PrimeVue.DatePicker);
app.component("p-selectbutton", PrimeVue.SelectButton);
app.mount("#app");
