<?php

namespace Drupal\wordsonline_connector\Entity;

/**
 * Struct of a api response.
 */
class JobListDataResponse
{
  public $id = 0;
  public $label = "";
  public $request_id = 0;
  public $order_id = 0;
  public $request_name = "";
  public $status = "N/A";
  public $due_date;
  public $job_type = -1;
  public $job_items_count = 0;
  public $job_id = 0;
  public $source_language_name = "";
  public $source_language_code = "";
  public $target_language_name = "";
  public $target_language_code = "";
  public $request_guid = "";
  public $project_id = 0;
  public $service_level = "";
  public $content_type = "";
  public $state = "";
  public $is_show_view_quote = 0;
  public $is_show_view_job_item = 0;
  public $is_show_import = 0;
  public $is_show_reimport = 0;
  public $is_show_download = 0;
  public $is_show_retry = 0;
  public $is_show_view_job = 0;

  /**
   * Constructor.
   *
   * @param int $id
   *   WordsOnline Job Id.
   * @param string $request_name
   *   Request Name.
   * @param string $request_guid
   * Request Guid.
   */
  public function __construct($id, $request_name, $request_guid)
  {
    $this->id = $id;
    $this->request_name = $request_name;
    $this->request_guid = $request_guid;
  }

}
