<?php

namespace Drupal\workflow\Entity;

use Drupal\Core\Entity\EntityInterface;

/**
 * Provides an interface for workflow manager.
 *
 * Contains lost of functions from D7 workflow.module file.
 */
interface WorkflowManagerInterface {

  /********************************************************************
   * Helper functions.
   */

  /**
   * Returns an array of workflow fields for the given content entity type ID.
   *
   * @param string $entity_type_id
   *   The ID of the content entity type to investigate.
   *
   * @return array
   *   An array of workflow field map definitions, keyed by field name. Each
   *   value is an array with two entries:
   *   - type: The field type.
   *   - bundles: The bundles in which the field appears, as array with entity
   *     types as keys and the array of bundle names as values.
   *
   * @see \Drupal\comment\CommentManagerInterface::getFields()
   * @see \Drupal\Core\Entity\EntityFieldManager::getFieldMapByFieldType
   * @see \Drupal\Core\Entity\EntityManagerInterface::getFieldMap()
   */
  public function getFieldMap($entity_type_id = '');

  /**
   * Gets the current state ID of a given entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   An entity.
   * @param string $field_name
   *   A field name.
   *
   * @return string
   *   The current State ID.
   *
   * @deprecated in workflow:1.8 and will be removed in a future version.
   * @see workflow_node_current_state()
   * @see WorkflowTargetEntity->getCurrentStateId()
   */
  public static function getCurrentStateId(EntityInterface $entity, $field_name = '');

  /**
   * Gets the previous state ID of a given entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   An entity.
   * @param string $field_name
   *   A field_name.
   *
   * @return string
   *   The previous State ID.
   *
   * @deprecated in workflow:1.8 and will be removed in a future version.
   * @see workflow_node_previous_state()
   * @see WorkflowTargetEntity->getPreviousStateId()
   */
  public static function getPreviousStateId(EntityInterface $entity, $field_name = '');

}
