<?php

namespace Drupal\workflow_notifications\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Generates a list of workflow_notification entities.
 */
class WorkflowNotificationListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Label');
    $header['from_sid'] = $this->t('From State');
    $header['to_sid'] = $this->t('To State');
    $header['when_to_trigger'] = $this->t('When To Trigger');
    $header += parent::buildHeader();
    return $header;
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row = [];

    /** @var \Drupal\workflow\WorkflowTypeAttributeTrait $entity */
    $wid = workflow_url_get_workflow()->id();
    if ($wid <> $entity->getWorkflowId()) {
      return $row;
    }

    $from_sid = $entity->from_sid;
    $to_sid = $entity->to_sid;
    // @todo This should be moved into Workflow service.
    $state_options = ['all' => $this->t('Any State')];
    $state_options += workflow_allowed_workflow_state_names($wid, FALSE, TRUE);
    $triggers = workflow_notifications_get_trigger_values();
    $row['label'] = $entity->label();
    $row['from_sid'] = $state_options[$from_sid] ?? $from_sid;
    $row['to_sid'] = $state_options[$to_sid] ?? $to_sid;
    $row['when_to_trigger'] = match ($entity->when_to_trigger) {
      'before_state_change'
      => $this->t('%days days before State change', ['%days' => $entity->days]),
      'no_state_change'
      => $this->t('%days days after last State change', ['%days' => $entity->days]),
      default
      => $triggers[$entity->when_to_trigger],
    };
    $row += parent::buildRow($entity);
    return $row;
  }

}
