<?php

namespace Drupal\workflow_notifications\Entity;

use Drupal\workflow\Entity\WorkflowInterface;
use Drupal\workflow\Entity\WorkflowTransitionInterface;

/**
 * Defines a Workflow Notification entity.
 *
 * @package Drupal\workflow_notifications\Entity
 */
interface WorkflowNotificationInterface {

  /**
   * Returns the Workflow ID of this object.
   *
   * @return string
   *   Workflow Id.
   */
  public function getWorkflowId();

  /**
   * Returns the Workflow object of this object.
   *
   * @return \Drupal\workflow\Entity\Workflow
   *   Workflow object.
   */
  public function getWorkflow();

  /**
   * Sets the Workflow.
   *
   * @param \Drupal\workflow\Entity\WorkflowInterface|null $workflow
   *   The Workflow object.
   */
  public function setWorkflow(?WorkflowInterface $workflow = NULL);

  /**
   * Load WorkflowNotifications.
   *
   * @param string $from_sid
   *   The From State ID.
   * @param string $to_sid
   *   The To State ID.
   * @param string $wid
   *   The Workflow ID.
   * @param string $trigger
   *   Determines the triggering moment.
   * @param int $days
   *   Number of days 'before_state_change'.
   * @param string $entity_type
   *   The Notification type.
   *
   * @return \Drupal\workflow_notifications\Entity\WorkflowNotificationInterface[]
   *   An array of Notifications.
   */
  public static function loadMultipleByProperties($from_sid, $to_sid, $wid, $trigger, $days, $entity_type = 'workflow_notify');

  /**
   * Sends messages to all recipients for 1 state change.
   *
   * @param string $trigger
   *   Determines the triggering moment.
   * @param \Drupal\workflow\Entity\WorkflowTransitionInterface $transition
   *   The Transition that triggers the Notification.
   *
   * @see _workflow_notifications_mail_trigger()
   * @see _workflow_notifications_sms_trigger()
   */
  public function sendMessages(string $trigger, WorkflowTransitionInterface $transition);

}
