<?php

namespace Drupal\workflow_sms_notify\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\workflow\WorkflowTypeAttributeTrait;
use Drupal\workflow_notifications\Form\WorkflowNotificationForm;

/**
 * A form with details for the Notification.
 */
class WorkflowSmsNotificationForm extends WorkflowNotificationForm {

  use WorkflowTypeAttributeTrait;

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $notification = $this->entity;

    $role_options = workflow_allowed_user_role_names('');
    unset($role_options['anonymous']);
    // Overwrite default values.
    $form['receivers']['#title'] =$this->t('SMS');
    // @todo Add validation for phone number.
    $form['receivers']['phone_num'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Phone Numbers'),
      '#default_value' => $notification->phone_num,
      '#description' => $this->t('Enter valid phone numbers, one per line.'),
    ];
    unset($form['receivers']['mail_ids']);
    unset($form['message']['subject']);
    $form['message']['#weight'] = 11;
    $form['note']['#weight'] = 12;
    $form['tokens']['#weight'] = 13;
    unset($form['mail_to']);

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $notification = $this->entity;
    $status = parent::save($form, $form_state);

    $form_state->setRedirect('entity.workflow_sms_notify.collection', [
      'workflow_type' => $this->getWorkflowId(),
      'workflow_sms_notify' => $notification->id(),
    ]);

    return $status;
  }

}
