<?php

namespace Drupal\workflow_notifications\Plugin\QueueWorker;

use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\workflow\Entity\WorkflowScheduledTransition;

/**
 * Process mail to the scheduled entities. Called from hook_cron.
 *
 * @QueueWorker(
 *   id = "workflow_notifications.send",
 *   title = @Translation("Workflow mail trigger for scheduled entities."),
 *   cron = {"time" = 60},
 * )
 */
class ScheduleMailQueue extends QueueWorkerBase {

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $notification = $data['entity'];

    $transitions = [];
    switch ($notification->when_to_trigger) {
      case 'on_state_change':
        // This state change has just occurred.
        break;

      case 'before_state_change':
        // Read the scheduled state changes.
        // Note: $day can also be 0.
        $day = $notification->days;
        // Start counting from last midnight.
        $start_time = strtotime("today midnight + $day days");
        $end_time = strtotime("tomorrow midnight + $day days ");
        $transitions = WorkflowScheduledTransition::loadBetween($start_time, $end_time);
        break;

      case 'no_state_change':
        // Read the last state changes from the past for each entity.
        $transitions = _workflow_notifications_read_last_transitions($notification);
        break;

      default:
        // Unexpected value.
        break;
    }

    $trigger = $notification->getDefaultTriggerId();
    foreach ($transitions as $id => $transition) {
      $notification->sendMessages($trigger, $transition);
    }
  }

}
