<?php

namespace Drupal\workflow_participants;

use Drupal\content_moderation_notifications\ContentModerationNotificationInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\WorkflowInterface;

/**
 * A class for reacting to entity operations.
 */
class EntityOperations {

  use StringTranslationTrait;

  /**
   * Form builder for moderation state transitions.
   *
   * @param string $entity_type
   *   The entity type ID.
   * @param \Drupal\workflows\WorkflowInterface $workflow
   *   The workflow entity.
   * @param array $form
   *   The form definition.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   *
   * @see static::alterWorkflowTransitionsForm
   */
  public static function workflowTransitionsFormBuilder($entity_type, WorkflowInterface $workflow, array &$form, FormStateInterface $form_state) {
    $transition_id = $form_state->getValue('id');
    foreach (['editor_transitions', 'reviewer_transitions'] as $enabled) {
      $transitions = $workflow->getThirdPartySetting('workflow_participants', $enabled, []);
      if ($form_state->getValue($enabled)) {
        $transitions[$transition_id] = $transition_id;
      }
      else {
        unset($transitions[$transition_id]);
      }
      $workflow->setThirdPartySetting('workflow_participants', $enabled, $transitions);
    }
  }

  /**
   * Form builder for content moderation notification entities.
   *
   * @param string $entity_type
   *   The entity type ID.
   * @param \Drupal\content_moderation_notifications\ContentModerationNotificationInterface $notification
   *   The notification entity.
   * @param array $form
   *   The form definition.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   */
  public static function notificationFormBuilder($entity_type, ContentModerationNotificationInterface $notification, array &$form, FormStateInterface $form_state) {
    foreach ($form_state->getValue('workflow_participants') as $key => $value) {
      $notification->setThirdPartySetting('workflow_participants', $key, (bool) $value);
    }
  }

}
