<?php

namespace Drupal\workflow_participants\Hook;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\workflow_participants\Entity\Routing\RouteProvider;

/**
 * Low level hook implementations.
 *
 * These need to be separated to avoid circular dependency issues.
 */
class WorkflowParticipantsLowerHooks {

  /**
   * Implements hook_entity_type_alter().
   */
  #[Hook('entity_type_alter')]
  public function entityTypeAlter(array &$entityTypes): void {
    foreach ($entityTypes as $entityTypeId => $entityType) {
      if ($entityType->isRevisionable() && $entityTypeId !== 'workflow_participants') {
        $this->addWorkflowParticipantsEntityType($entityType);
      }
    }
  }

  /**
   * Adds workflow participant functionality to a given entity type.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $type
   *   The entity type for which to add workflow participant functionality.
   */
  protected function addWorkflowParticipantsEntityType(EntityTypeInterface $type): void {
    // Set workflow participants link template.
    if (!$type->hasLinkTemplate('workflow-participants')) {
      $type->setLinkTemplate('workflow-participants', $type->getLinkTemplate('canonical') . '/workflow-participants');
    }

    // Add workflow participants route provider.
    $providers = $type->getRouteProviderClasses();
    if (empty($providers['workflow_participants'])) {
      $providers['workflow_participants'] = RouteProvider::class;
      $type->setHandlerClass('route_provider', $providers);
    }
  }

}
