<?php

declare(strict_types=1);

namespace Drupal\workspaces_access\Hook;

use Drupal\Core\Cache\CacheTagsInvalidatorInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\workspaces\Entity\Workspace;

/**
 * Defines a class for reacting to workspace entity hooks.
 */
class WorkspaceEntity {

  public function __construct(
    protected CacheTagsInvalidatorInterface $cacheTagsInvalidator,
  ) {}

  /**
   * Implements hook_ENTITY_TYPE_insert() for workspace entities.
   */
  #[Hook('workspace_insert')]
  public function workspaceInsert(Workspace $workspace): void {
    // Invalidate permission cache when a new workspace is created.
    $this->invalidatePermissionCache();
  }

  /**
   * Implements hook_ENTITY_TYPE_delete() for workspace entities.
   */
  #[Hook('workspace_delete')]
  public function workspaceDelete(Workspace $workspace): void {
    // Invalidate permission cache when a workspace is deleted.
    $this->invalidatePermissionCache();
  }

  /**
   * Invalidates permission-related caches.
   */
  protected function invalidatePermissionCache(): void {
    // Invalidate permission caches to ensure new permissions are recognized.
    $this->cacheTagsInvalidator->invalidateTags(['config:workspaces_access.permissions']);
  }

}
