<?php

declare(strict_types=1);

namespace Drupal\workspaces_access;

/**
 * Provides dynamic permissions for workspaces access.
 */
class WorkspacesAccessPermissions {

  /**
   * Returns an array of dynamic permissions.
   *
   * @return array
   *   An array of permissions.
   */
  public static function permissions(): array {
    // Use the module's permission hook for consistency.
    if (function_exists('workspaces_access_permissions')) {
      return workspaces_access_permissions();
    }

    // Fallback when module is not loaded.
    $permissions = [];
    $permissions["workspace_live_view_content"] = [
      'title' => '@ Live - View content',
      'description' => 'Role can view content in workspace. Requires relevant permissions (e.g., "view article content") for operations.',
      'restrict access' => TRUE,
    ];
    $permissions["workspace_live_add_content"] = [
      'title' => '@ Live - Add content',
      'description' => 'Role can create content in workspace. Requires "View" permission for add functionality and relevant permissions (e.g., "create article content") for operations.',
      'restrict access' => TRUE,
    ];
    $permissions["workspace_live_edit_content"] = [
      'title' => '@ Live - Edit content',
      'description' => 'Role can edit content in workspace. Requires "View" permission for edit functionality and relevant permissions (e.g., "edit article content") for operations.',
      'restrict access' => TRUE,
    ];
    $permissions["workspace_live_remove_content"] = [
      'title' => '@ Live - Remove content',
      'description' => 'Role can delete content in workspace. Requires relevant permissions (e.g., "delete article content") for operations.',
      'restrict access' => TRUE,
    ];

    return $permissions;
  }

}
