<?php

declare(strict_types=1);

namespace Drupal\workspaces_access;

use Drupal\workspaces\WorkspaceRepositoryInterface;

/**
 * Manages workspace access permissions.
 */
class WorkspaceAccessManager implements WorkspaceAccessManagerInterface {

  public function __construct(
    protected WorkspaceRepositoryInterface $workspaceRepository,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function getWorkspacePermissions(): array {
    return WorkspacesAccessPermissions::permissions();
  }

  /**
   * {@inheritdoc}
   */
  public function getWorkspacePermission(string $workspace_id, string $operation = 'edit'): string {
    return "workspace_{$workspace_id}_{$operation}_content";
  }

}
