<?php

declare(strict_types=1);

namespace Drupal\workspaces_access;

/**
 * Interface for the workspace access manager.
 */
interface WorkspaceAccessManagerInterface {

  /**
   * Gets all workspace permissions.
   *
   * @return array
   *   An array of permission definitions.
   */
  public function getWorkspacePermissions(): array;

  /**
   * Gets permission for a specific workspace and operation.
   *
   * @param string $workspace_id
   *   The workspace ID.
   * @param string $operation
   *   The operation (add, edit, remove).
   *
   * @return string
   *   The permission string.
   */
  public function getWorkspacePermission(string $workspace_id, string $operation = 'edit'): string;

}
