# Writesonic AI Analytics 

A Drupal module that intercepts incoming HTTP requests and sends analytics data to an external ingestion server for real-time tracking and monitoring.

## Table of Contents

- [Features](#features)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Security](#security)
- [API](#api)
- [Development](#development)
- [Troubleshooting](#troubleshooting)
- [License](#license)

## Features

- **Request Interception**: Automatically captures analytics data from all incoming requests
- **Geo-location Detection**: Determines user country from various headers (Cloudflare, X-Country-Code, etc.)
- **Flexible Configuration**: Configure via Drupal admin interface or environment variables
- **Security-first**: Requires API key authentication for data transmission
- **Error Handling**: Graceful error handling with logging for failed analytics requests

## Requirements

- Drupal 9, 10, or 11
- PHP 7.4 or higher
- HTTP Client (GuzzleHttp) - included with Drupal core

## Installation

1. **Download the module**:
   ```bash
   # Place the module in your custom modules directory
   cp -r writesonic_ai_analytics /path/to/drupal/web/modules/custom/
   ```

2. **Enable the module**:
   ```bash
   ddev drush en writesonic_ai_analytics
   ```
   
   Or via the admin interface: `Administration → Extend`

3. **Clear cache**:
   ```bash
   ddev drush cr ## or ddev drush cr
   ```

4. **Launch Drupal CMS**:
   ```bash
   ddev launch
   ```

## Configuration

### Via Admin Interface

Navigate to `Administration → Configuration → System → Writesonic AI Analytics`

**Required Settings:**
- **API Key**: Authentication key for your analytics ingestion server

**Optional Settings:**
- **Enable Analytics Tracking**: Toggle to enable/disable tracking (enabled by default)

### Via Environment Variables

For production deployments, you can override settings with environment variables:

```bash
# Override configuration
export ANALYTICS_API_KEY="your-api-key-here"
export ANALYTICS_ENABLED="true"  # or "false" to disable
```

## Usage

Once configured, the module automatically:

1. Intercepts all incoming HTTP requests (except excluded paths)
2. Extracts relevant analytics data from request headers
3. Determines geographic location from various header sources
4. Sends data to your configured analytics endpoint

### Excluded Paths

The following paths are automatically excluded from analytics tracking:

- `/admin/*` - Drupal admin interface
- `/sites/default/files/*` - Static file uploads
- `/contextual/*` - Contextual links
- `/system/*` - System routes
- `/core/*`, `/modules/*`, `/themes/*` - Asset files

## Security

This module follows Drupal security best practices:

- **Input Validation**: All user input is properly validated and sanitized
- **API Key Security**: API keys are securely stored and handled
- **Permission Control**: Only users with "administer site configuration" permission can modify settings
- **Request Timeout**: HTTP requests include timeouts to prevent blocking
- **Error Handling**: Graceful error handling prevents site disruption

## API

### Data Format

Analytics data is sent as JSON POST requests:

```json
{
  "ip": "192.168.1.1",
  "x_real_ip": "203.0.113.1",
  "ua": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36",
  "referrer": "https://example.com/previous-page",
  "country_code": "US",
  "url": "https://example.com/page?param=value",
  "cleaned_url": "https://example.com/page",
  "method": "GET",
  "x_forwarded_for": "203.0.113.1, 70.41.3.18",
  "response_status": "200"
}
```

### Request Headers

```
Content-Type: application/json
x-api-key: your-configured-api-key
```

### Geo-location Detection

The module detects user country from headers in this priority order:

1. **CF-IPCountry** (Cloudflare)
2. **X-Country-Code** (Custom/CDN)
3. **GEOIP-Country-Code** (GeoIP modules)
4. **X-Country** (Generic)

## Development

### Services

The module provides these services:

- `writesonic_ai_analytics.request_logger_service` - Main event subscriber
- `writesonic_ai_analytics.config_service` - Configuration management

### Extending the Module

You can extend the module by:

1. **Data Fields**: Extend `RequestLoggerSubscriberService` to capture additional request data
2. **Configuration Service**: Use or extend `AnalyticsConfigService` to manage and customize analytics configuration options
3. **Filtering**: Add custom logic to exclude specific paths or conditions

### Code Standards

This module follows:
- Drupal Coding Standards
- PHP-FIG PSR-12 coding style
- Drupal API best practices
- Security coding practices

## Troubleshooting

### Common Issues

1. **Tracking Not Working**:
   - Verify API key and endpoint are configured
   - Check that tracking is enabled in settings
   - Review Drupal logs for error messages

2. **Configuration Redirects**:
   - The module redirects to config page if API key is missing
   - Configure the required settings to stop redirects

3. **Performance Concerns**:
   - Analytics requests are non-blocking with timeouts
   - Failed requests are logged but don't affect site performance
   - Admin paths are excluded to avoid tracking backend activity

### Debugging

Enable Drupal logging and check for module messages:

```bash
drush watchdog:show --filter=writesonic_ai_analytics
```

Check the status report for configuration issues:
`Administration → Reports → Status report`

## License

This module is licensed under the GNU General Public License v2.0 or later, the same license as Drupal core.


