<?php

namespace Drupal\wsdata_field\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Web Service Call entity.
 *
 * @ConfigEntityType(
 *   id = "wsfield_config",
 *   label = @Translation("WSField Configurations"),
 *   handlers = {
 *     "form" = {
 *       "add" = "Drupal\wsdata_field\Form\WSFieldConfigForm",
 *       "edit" = "Drupal\wsdata_field\Form\WSFieldConfigForm",
 *     },
 *   },
 *   config_prefix = "wsfield_config",
 *   admin_permission = "administer site configuration",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid"
 *   },
 *   config_export = {
 *     "id",
 *     "wscall",
 *     "label",
 *     "replacements",
 *     "returnToken",
 *     "data",
 *     "languageHandling",
 *   }
 * )
 */
class WSFieldConfig extends ConfigEntityBase {
  /**
   * The Web Service Call ID.
   *
   * @var string
   */
  protected $id;

  /**
   * Webservice field configurations.
   *
   * @var string
   */
  public $wscall;

  /**
   * Array of replacements variables.
   *
   * @var array
   */
  public $replacements;

  /**
   * Return token.
   *
   * @var string
   */
  public $returnToken;

  /**
   * Extra data to make the web service call.
   *
   * @var array
   */
  public $data;

  /**
   * Language handling.
   *
   * @var object
   */
  public $languageHandling;

}
