<?php

namespace Drupal\wsdata\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\State\State;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Admin form for the WSData module.
 */
class WSDataAdminForm extends ConfigFormBase {

  /**
   * The state service.
   *
   * @var \Drupal\Core\State\State
   */
  protected $state;

  /**
   * {@inheritdoc}
   */
  public function __construct(
    ConfigFactoryInterface $config_factory,
    State $state
  ) {
    $this->setConfigFactory($config_factory);
    $this->state = $state;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('state')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'wsdata_admin_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'wsdata_admin.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['debug_mode'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Debug Mode'),
      '#description' => $this->t('Deubg mode logs and prints all queries'),
      '#default_value' => $this->state->get('wsdata_debug_mode'),
    ];

    $form['performance_log'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Performance log'),
      '#description' => $this->t('Log WSData performace to watchdog'),
      '#default_value' => $this->state->get('wsdata_performance_log', 0),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $this->state->set('wsdata_debug_mode', $values['debug_mode']);
    $this->state->set('wsdata_performance_log', $values['performance_log']);
    parent::submitForm($form, $form_state);
  }

}
