<?php

namespace Drupal\wse_parallel\EventSubscriber;

use Drupal\wse_parallel\ParallelEditWarningService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Event subscriber to show parallel edit warnings on every request.
 */
class ParallelEditWarningSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a ParallelEditWarningSubscriber object.
   *
   * @param \Drupal\wse_parallel\ParallelEditWarningService $warningService
   *   The parallel edit warning service.
   */
  public function __construct(
    protected ParallelEditWarningService $warningService,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    // Run on every request, after routing has occurred.
    $events[KernelEvents::REQUEST][] = ['onRequest', 0];
    return $events;
  }

  /**
   * Shows parallel edit warnings if in edit mode.
   *
   * @param \Symfony\Component\HttpKernel\Event\RequestEvent $event
   *   The request event.
   */
  public function onRequest(RequestEvent $event): void {
    // Only process main requests (not sub-requests).
    if (!$event->isMainRequest()) {
      return;
    }

    // Show warnings for the current page.
    $this->warningService->showWarningsForCurrentPage();
  }

}
